/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.misc;

import alma.obsprep.ot.editors.misc.CalendarPopup;
import alma.obsprep.util.MiscUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.time.ZonedDateTime;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class CalendarButton
extends JButton
implements PropertyChangeListener,
ActionListener {
    private static final long serialVersionUID = 955496905445609210L;
    String dateParam = "date";
    ZonedDateTime targetDate = null;
    private static final URL calendarImage = MiscUtils.findResource(null, "alma/obsprep/ot/gui/resources/Calendar.png");

    public CalendarButton() {
        if (calendarImage != null) {
            this.setIcon(new ImageIcon(calendarImage));
        } else {
            this.setText("Date");
        }
        this.setMargin(CalendarPopup.NO_INSETS);
        this.setOpaque(false);
        this.addActionListener(this);
    }

    public CalendarButton(ZonedDateTime zonedDateTime) {
        this();
        this.init(null, zonedDateTime);
    }

    public CalendarButton(String string, ZonedDateTime zonedDateTime) {
        this();
        this.init(string, zonedDateTime);
    }

    public void init(String string, ZonedDateTime zonedDateTime) {
        if (string == null) {
            string = "date";
        }
        this.dateParam = string;
        this.targetDate = zonedDateTime;
    }

    public ZonedDateTime getTargetDate() {
        return this.targetDate;
    }

    public void setTargetDate(ZonedDateTime zonedDateTime) {
        this.targetDate = zonedDateTime;
    }

    public String getDateParam() {
        return this.dateParam;
    }

    public void setDateParam(String string) {
        this.dateParam = string;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this) {
            ZonedDateTime zonedDateTime = this.getTargetDate();
            CalendarPopup calendarPopup = CalendarPopup.createCalendarPopup(this.getDateParam(), zonedDateTime, this);
            calendarPopup.addPropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        if (this.dateParam.equalsIgnoreCase(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() instanceof ZonedDateTime) {
            this.targetDate = (ZonedDateTime)propertyChangeEvent.getNewValue();
        }
    }
}

