/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spectralvisual;

import alma.obsprep.bo.enumerations.SideBandUse;
import alma.obsprep.bo.schedblock.Range;
import alma.valuetypes.Frequency;
import java.util.ArrayList;
import java.util.List;

public class SpectralRangeRepresentation {
    private Range frequenciesGHz;
    private int level;
    private int depth;
    private SideBandUse sideband;
    private RangeType type;
    private SpectralRangeRepresentation mirror;
    private SpectralRangeRepresentation parent;
    private final List<SpectralRangeRepresentation> children;
    private boolean error;
    private boolean isHighlighted;
    private String label;

    public SpectralRangeRepresentation(double d, double d2, SideBandUse sideBandUse, RangeType rangeType) {
        this.frequenciesGHz = new Range(d, d2);
        this.sideband = sideBandUse;
        this.type = rangeType;
        this.level = 0;
        this.depth = 0;
        this.mirror = null;
        this.error = false;
        this.isHighlighted = false;
        this.label = null;
        this.parent = null;
        this.children = new ArrayList<SpectralRangeRepresentation>();
    }

    public Frequency getMinFrequency() {
        return Frequency.createFrequencyGHZ(this.frequenciesGHz.min());
    }

    public Frequency getMaxFrequency() {
        return Frequency.createFrequencyGHZ(this.frequenciesGHz.max());
    }

    public double getMinFrequencyGHz() {
        return this.frequenciesGHz.min();
    }

    public double getMaxFrequencyGHz() {
        return this.frequenciesGHz.max();
    }

    public void setMinFrequency(Frequency frequency) {
        this.setMinFrequency(frequency.getContentInGHz());
    }

    public void setMaxFrequency(Frequency frequency) {
        this.setMaxFrequency(frequency.getContentInGHz());
    }

    public void setMinFrequency(double d) {
        this.frequenciesGHz = new Range(d, this.getMaxFrequencyGHz());
    }

    public void setMaxFrequency(double d) {
        this.frequenciesGHz = new Range(this.getMinFrequencyGHz(), d);
    }

    public void setRange(double d, double d2) {
        this.frequenciesGHz = new Range(d, d2);
    }

    public void setMirror(SpectralRangeRepresentation spectralRangeRepresentation) {
        if (this.mirror != null) {
            this.mirror.mirror = null;
        }
        this.mirror = spectralRangeRepresentation;
        if (spectralRangeRepresentation != null) {
            spectralRangeRepresentation.mirror = this;
        }
    }

    public void setParent(SpectralRangeRepresentation spectralRangeRepresentation) {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.parent = spectralRangeRepresentation;
        if (spectralRangeRepresentation != null) {
            spectralRangeRepresentation.addChild(this);
        }
        this.setError(!spectralRangeRepresentation.frequenciesGHz.contains(this.frequenciesGHz));
    }

    private void addChild(SpectralRangeRepresentation spectralRangeRepresentation) {
        if (!this.children.contains(spectralRangeRepresentation)) {
            this.children.add(spectralRangeRepresentation);
        }
    }

    private void removeChild(SpectralRangeRepresentation spectralRangeRepresentation) {
        this.children.remove(spectralRangeRepresentation);
    }

    public int getLevel() {
        return this.level;
    }

    public int getDepth() {
        return this.depth;
    }

    public SideBandUse getSideband() {
        return this.sideband;
    }

    public RangeType getType() {
        return this.type;
    }

    public SpectralRangeRepresentation getMirror() {
        return this.mirror;
    }

    public SpectralRangeRepresentation getParent() {
        return this.parent;
    }

    public List<SpectralRangeRepresentation> getChildren() {
        return this.children;
    }

    public boolean isError() {
        return this.error;
    }

    public boolean isHighlighted() {
        return this.isHighlighted;
    }

    public String getLabel() {
        return this.label;
    }

    public Range getFrequenciesGHz() {
        return this.frequenciesGHz;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public void setDepth(int n) {
        this.depth = n;
    }

    public void setError(boolean bl) {
        this.error = bl;
    }

    public void setHighlighted(boolean bl) {
        this.isHighlighted = bl;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    protected static enum RangeType {
        Primary,
        Secondary,
        Suppressed;

    }

    protected static enum DSBType {
        Rejection,
        Separation,
        Both;

    }
}

