/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.toplevel;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.valdef.ProblemListEvent;
import alma.obsprep.ot.valdef.ProblemListListener;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.Problem;
import alma.obsprep.util.Convert;
import java.util.Date;

class ProblemPrinter
implements ProblemListListener {
    private ProblemListModel model;
    private final ObservingToolGui gui;

    ProblemPrinter(ObservingToolGui observingToolGui) {
        this.gui = observingToolGui;
    }

    void setModel(ProblemListModel problemListModel) {
        if (this.model != null) {
            this.model.removeProblemListListener(this);
        }
        this.model = problemListModel;
        this.model.addProblemListListener(this);
    }

    @Override
    public void problemListChanged(ProblemListEvent problemListEvent) {
        if (problemListEvent.getType() == 1062) {
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            this.compileResults(stringBuilder, stringBuilder2);
            String string = stringBuilder.toString();
            String string2 = stringBuilder2.toString();
            this.gui.addInformationMessage(string, string2);
        }
    }

    private void compileResults(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        int n = 0;
        int n2 = 0;
        stringBuilder2.append("<table>");
        for (int i = 0; i < this.model.getSize(); ++i) {
            Problem problem = this.model.getProblemAt(i);
            if (problem.isError()) {
                ++n2;
            } else if (problem.isWarning()) {
                ++n;
            }
            stringBuilder2.append("<tr><td rowspan=1 valign=top>");
            stringBuilder2.append(problem.getSeverity());
            stringBuilder2.append(" in ");
            String string = problem.getResource().toString();
            if (problem.getResource() instanceof BusinessObject) {
                string = ((BusinessObject)problem.getResource()).getNameOrDefault();
            }
            stringBuilder2.append(string);
            stringBuilder2.append("</td></tr>");
            stringBuilder2.append("<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            stringBuilder2.append(problem.getDescription());
            stringBuilder2.append("</td></tr>");
            stringBuilder2.append("<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            stringBuilder2.append(problem.getSuggestion());
            stringBuilder2.append("</td></tr>");
        }
        stringBuilder2.append("</table>");
        stringBuilder.append(Convert.convertToDateTime(new Date()));
        stringBuilder.append("&nbsp; Project ");
        if (n2 > 0) {
            stringBuilder.append("FAILED");
        } else {
            stringBuilder.append("PASSED");
        }
        stringBuilder.append(" validation with ");
        stringBuilder.append(n2);
        stringBuilder.append(" error");
        if (n2 != 1) {
            stringBuilder.append('s');
        }
        stringBuilder.append(" and ");
        stringBuilder.append(n);
        stringBuilder.append(" warning");
        if (n != 1) {
            stringBuilder.append('s');
        }
    }
}

