/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.valuetypes;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnitMap;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;

public abstract class AbstractValueUnitPairModel
extends Model {
    private final FieldID valueFID;
    private final FieldID unitFID;
    private final DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.ENGLISH){

        @Override
        public String getNaN() {
            return "NaN";
        }

        @Override
        public String getInfinity() {
            return "Infinity";
        }
    };
    private NumberFormat numberFormat = new DecimalFormat("0.00000", this.decimalFormatSymbols);

    public AbstractValueUnitPairModel(Object object, FieldID fieldID, FieldID fieldID2) {
        super(object);
        this.valueFID = fieldID;
        this.unitFID = fieldID2;
    }

    public abstract ValueUnitPair getVUP();

    public UnitMap unitMap() {
        ValueUnitPair valueUnitPair = this.getVUP();
        if (valueUnitPair == null) {
            return null;
        }
        return this.getVUP().unitMap();
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        if (numberFormat == null) {
            Log.logger((Object)this).warning("format cannot be null");
            return;
        }
        this.numberFormat = numberFormat;
    }

    @Override
    public void publish() {
        ValueUnitPair valueUnitPair = this.getVUP();
        if (valueUnitPair == null) {
            return;
        }
        if (!valueUnitPair.hasContent()) {
            valueUnitPair.setContent(0.0);
        }
        String string = this.numberFormat.format(valueUnitPair.getContent());
        String string2 = valueUnitPair.getUnit();
        this.publish(this.valueFID, string);
        this.publish(this.unitFID, string2);
    }

    @Override
    public abstract Object update(Editor var1, FieldID var2, Object var3);

    public FieldID getValueFID() {
        return this.valueFID;
    }

    public FieldID getUnitFID() {
        return this.unitFID;
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        return this.decimalFormatSymbols;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }
}

