/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.problems;

import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.obsprep.problems.Problem;

public class DefaultProblem
implements Problem {
    private final int severity;
    private final String description;
    private final String suggestion;
    private final Object resource;

    private DefaultProblem(int n, String string, String string2, Object object) {
        this.severity = n;
        this.description = string == null ? "" : string;
        this.suggestion = string2 == null ? "" : string2;
        this.resource = object == null ? "" : object;
    }

    @Override
    public boolean isEqual(Problem problem) {
        return this.getSeverity().equals(problem.getSeverity()) && this.getDescription().equals(problem.getDescription()) && this.getSuggestion().equals(problem.getSuggestion());
    }

    public static Problem createSuccess(String string, String string2, IBusinessObject iBusinessObject) {
        return new DefaultProblem(100, string, string2, iBusinessObject);
    }

    public static Problem createInfo(String string, String string2, IBusinessObject iBusinessObject) {
        return new DefaultProblem(101, string, string2, iBusinessObject);
    }

    public static Problem createWarning(String string, String string2, IBusinessObject iBusinessObject) {
        return new DefaultProblem(102, string, string2, iBusinessObject);
    }

    public static Problem createError(String string, String string2, IBusinessObject iBusinessObject) {
        return new DefaultProblem(103, string, string2, iBusinessObject);
    }

    @Override
    public String getSeverity() {
        return switch (this.severity) {
            case 103 -> "Error";
            case 102 -> "Warning";
            case 101 -> "Info";
            case 100 -> "Success";
            default -> "<Unknown Severity>";
        };
    }

    @Override
    public boolean isError() {
        return this.severity == 103;
    }

    @Override
    public boolean isWarning() {
        return this.severity == 102;
    }

    @Override
    public boolean isSuccess() {
        return this.severity == 100;
    }

    @Override
    public boolean isErrorOrWorse() {
        return this.severity >= 103;
    }

    @Override
    public boolean isWarningOrWorse() {
        return this.severity >= 102;
    }

    public String toString() {
        return "Problem@" + this.hashCode() + " [" + this.getSeverity() + "," + this.getDescription() + "," + String.valueOf(this.getResource()) + "," + this.getSuggestion() + "]";
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getSuggestion() {
        return this.suggestion;
    }

    @Override
    public Object getResource() {
        return this.resource;
    }
}

