/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.etc;

import alma.obsprep.util.CSVReader;
import alma.obsprep.util.MiscUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;

public class AtmosphereTable {
    private static File configPath;
    private static final String[] atmospheresFileName;
    public static final String[] WV_MAP;
    public static final double[] WV_MAP_VALUES;
    public static final int NUM_WV_POINTS = 7;
    private static Data[][] atmospheres;
    private static float[][] frequencies;
    private static float[] fstart;
    private static float[] fend;
    private static float[] deltaf;
    private static AtmosphereTable INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AtmosphereTable getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<AtmosphereTable> clazz = AtmosphereTable.class;
        synchronized (AtmosphereTable.class) {
            INSTANCE = new AtmosphereTable();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public static void setConfigPath(File file) {
        configPath = file;
    }

    private AtmosphereTable() {
        if (configPath == null) {
            configPath = new File(System.getProperty("otData.dir"));
        }
        try {
            this.fillAtmTable();
        }
        catch (IOException | NumberFormatException exception) {
            exception.printStackTrace();
        }
    }

    public Data lookup(float f, int n) {
        Data data = null;
        Data[] dataArray = atmospheres[n];
        if (f >= fstart[n] && f <= fend[n]) {
            int n2 = this.getIndex(f, n);
            if (n2 == 0 || n2 == frequencies[n].length) {
                return null;
            }
            float f2 = frequencies[n][n2 - 1];
            float f3 = frequencies[n][n2];
            float f4 = dataArray[n2 - 1].m_tau + (dataArray[n2].m_tau - dataArray[n2 - 1].m_tau) * (f - f2) / (f3 - f2);
            float f5 = dataArray[n2 - 1].m_tsky + (dataArray[n2].m_tsky - dataArray[n2 - 1].m_tsky) * (f - f2) / (f3 - f2);
            return new Data(f4, f5);
        }
        return data;
    }

    private int getIndex(float f, int n) {
        int n2 = (int)((f - fstart[n]) / deltaf[n]);
        while (frequencies[n][n2] > f) {
            --n2;
        }
        while (n2 < frequencies[n].length && f > frequencies[n][n2]) {
            ++n2;
        }
        return n2;
    }

    public DataTable lookup(double d, double d2, int n) {
        double d3;
        Vector<Data> vector = new Vector<Data>();
        Data[] dataArray = atmospheres[n];
        int n2 = 0;
        int n3 = dataArray.length - 1;
        if (d >= (double)fstart[n] && d <= (double)fend[n]) {
            d3 = (d - (double)fstart[n]) / (double)deltaf[n];
            n2 = (int)Math.floor(d3);
        }
        if (d2 >= (double)fstart[n] && d2 <= (double)fend[n]) {
            d3 = (d2 - (double)fstart[n]) / (double)deltaf[n];
            n3 = (int)Math.ceil(d3);
        }
        for (int i = n2; i <= n3; ++i) {
            vector.add(dataArray[i]);
        }
        d = fstart[n] + (float)n2 * deltaf[n];
        d2 = fstart[n] + (float)n3 * deltaf[n];
        return new DataTable(d, d2, deltaf[n], vector);
    }

    private void fillAtmTable() throws NumberFormatException, IOException {
        for (int i = 0; i < 7; ++i) {
            String[] stringArray;
            URL uRL = MiscUtils.findResource(configPath, atmospheresFileName[i]);
            if (uRL == null) {
                throw new IOException(String.valueOf(configPath) + " was not found.");
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            ArrayList<Data> arrayList = new ArrayList<Data>();
            ArrayList<Float> arrayList2 = new ArrayList<Float>();
            int n = 0;
            CSVReader cSVReader = new CSVReader(bufferedReader, ' ', '\'');
            while ((stringArray = cSVReader.readNext()) != null) {
                float f = Float.parseFloat(stringArray[0]);
                if (n == 0) {
                    AtmosphereTable.fstart[i] = f;
                }
                if (n == 1) {
                    AtmosphereTable.deltaf[i] = f - fstart[i];
                }
                AtmosphereTable.fend[i] = f;
                float f2 = Float.parseFloat(stringArray[1]);
                float f3 = Float.parseFloat(stringArray[2]);
                arrayList.add(new Data(f2, f3));
                arrayList2.add(Float.valueOf(f));
                ++n;
            }
            cSVReader.close();
            bufferedReader.close();
            AtmosphereTable.atmospheres[i] = arrayList.toArray(new Data[arrayList.size()]);
            float[] fArray = new float[arrayList2.size()];
            int n2 = 0;
            for (Float f : arrayList2) {
                fArray[n2] = f.floatValue();
                ++n2;
            }
            AtmosphereTable.frequencies[i] = fArray;
        }
    }

    public static void main(String[] stringArray) throws NumberFormatException, IOException {
        System.setProperty("otData.dir", "config/otData/");
        AtmosphereTable.getInstance().fillAtmTable();
    }

    static {
        atmospheresFileName = new String[]{"SKY.SPE0001.trim", "SKY.SPE0002.trim", "SKY.SPE0003.trim", "SKY.SPE0004.trim", "SKY.SPE0005.trim", "SKY.SPE0006.trim", "SKY.SPE0007.trim"};
        WV_MAP = new String[]{"0.472mm (1st Octile)", "0.658mm (2nd Octile)", "0.913mm (3rd Octile)", "1.262mm (4th Octile)", "1.796mm (5th Octile)", "2.748mm (6th Octile)", "5.186mm (7th Octile)"};
        WV_MAP_VALUES = new double[]{0.472, 0.658, 0.913, 1.262, 1.796, 2.748, 5.186};
        atmospheres = new Data[7][];
        frequencies = new float[7][];
        fstart = new float[7];
        fend = new float[7];
        deltaf = new float[7];
        INSTANCE = null;
    }

    public static class Data {
        private final float m_tau;
        private final float m_tsky;

        private Data(float f, float f2) {
            this.m_tau = f;
            this.m_tsky = f2;
        }

        public float getTau() {
            return this.m_tau;
        }

        public float getTsky() {
            return this.m_tsky;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("tau=");
            stringBuilder.append(String.format("%.3f", Float.valueOf(this.m_tau)));
            stringBuilder.append(", Tsky=");
            stringBuilder.append(String.format("%.3f", Float.valueOf(this.m_tsky)));
            stringBuilder.append(" K");
            return stringBuilder.toString();
        }
    }

    public static class DataTable {
        private final Data[] data;
        private final double minF;
        private final double maxF;
        private final double deltaF;

        private DataTable(double d, double d2, double d3, Vector<Data> vector) {
            this.minF = d;
            this.maxF = d2;
            this.deltaF = d3;
            this.data = vector.toArray(new Data[vector.size()]);
        }

        public Data getData(int n) {
            return this.data[n];
        }

        public float getTau(int n) {
            return this.getData((int)n).m_tau;
        }

        public float getTatm(int n) {
            return this.getData((int)n).m_tsky;
        }

        public double getF(int n) {
            return this.getMinF() + (double)n * this.getDeltaF();
        }

        public int size() {
            return this.data.length;
        }

        public double getMinF() {
            return this.minF;
        }

        public double getMaxF() {
            return this.maxF;
        }

        public double getDeltaF() {
            return this.deltaF;
        }
    }
}

