/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.obsprep.bo.obsproject.CalibrationTargetParameters;
import alma.obsprep.bo.obsproject.ControlBlock;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SinglePoint;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.CrossPattern;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.FillPattern;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.PointingPattern;
import alma.obsprep.bo.schedblock.QuerySource;
import alma.obsprep.bo.schedblock.RectanglePattern;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.ot.editors.spatialvisual.RectangleMosaic;
import alma.obsprep.services.generator.CalibratedGoalFieldSourceWorker;
import alma.obsprep.services.generator.ToBeSupportedException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.valuetypes.Angle;
import alma.valuetypes.AngularVelocity;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Speed;
import alma.valuetypes.UserAngle;
import alma.valuetypes.Velocity;
import java.util.List;
import java.util.Queue;

public class FieldSourceWorker {
    private final CalibratedGoalFieldSourceWorker worker;
    protected final ScienceGoal scienceGoal;
    protected String arrayType = ControlBlock.ARRAYREQUESTED_TWELVE_M;
    private FieldSource representative = null;

    public FieldSourceWorker(String string, ScienceGoal scienceGoal) {
        this.worker = new CalibratedGoalFieldSourceWorker(scienceGoal);
        this.scienceGoal = scienceGoal;
        this.arrayType = string;
        this.addTargetFieldSources(this.worker.getTargetFieldSources());
        this.worker.calculate();
    }

    public FieldSourceWorker(ScienceGoal scienceGoal) {
        this.worker = new CalibratedGoalFieldSourceWorker(scienceGoal);
        this.scienceGoal = scienceGoal;
        this.addTargetFieldSources(this.worker.getTargetFieldSources());
        this.worker.calculate();
    }

    private void addTargetFieldSources(List<FieldSource> list) throws WizardSBGenerationException {
        this.validate();
        for (TargetParameters targetParameters : this.scienceGoal.getTargetParameters()) {
            FieldSource fieldSource = FieldSource.createFieldSource();
            this.setupFieldSource(targetParameters, fieldSource);
            if (targetParameters == this.scienceGoal.getSoleTargetParameters()) {
                this.representative = fieldSource;
            }
            list.add(fieldSource);
        }
    }

    protected void validate() throws WizardSBGenerationException {
        for (TargetParameters targetParameters : this.scienceGoal.getTargetParameters()) {
            this.validate(targetParameters);
        }
    }

    private void validate(TargetParameters targetParameters) throws WizardSBGenerationException {
        String string = targetParameters.getType();
        if (TargetParameters.TYPE_F_MULTIPLEPOINTS.equals(string)) {
            if (targetParameters.getFieldSinglePointCount() != targetParameters.getFieldCount()) {
                String string2 = "Only SinglePoint is allowed for this field type : " + string;
                throw new WizardSBGenerationException(string2);
            }
            int n = 0;
            String string3 = targetParameters.getSourceName() + "-";
            for (SinglePoint singlePoint : targetParameters.getFieldSinglePoint()) {
                singlePoint.getCentre().setFieldName(string3 + ++n);
            }
        } else if (TargetParameters.TYPE_F_SINGLERECTANGLE.equals(string)) {
            Rectangle rectangle = (Rectangle)((Object)targetParameters.getField(0));
            if (rectangle.getLong().getContentInDefaultUnits() <= 0.0 || rectangle.getShort().getContentInDefaultUnits() <= 0.0 || rectangle.getSpacing().getContentInDefaultUnits() <= 0.0) {
                String string4 = "Mapping rectangle definition is invalid. Check your science goal";
                throw new WizardSBGenerationException(string4);
            }
        } else {
            throw new WizardSBGenerationException("Unknown TargetParameter type : " + string);
        }
    }

    protected FieldSource getRepresentativeFieldSource() {
        return this.representative;
    }

    protected void setupFieldSource(TargetParameters targetParameters, FieldSource fieldSource) {
        fieldSource.setName("Primary:");
        fieldSource.setSourceName(targetParameters.gettrueSourceName());
        Object object = targetParameters.gettrueSourceCoordinates();
        if (object != null) {
            fieldSource.setSourceCoordinates((SkyCoordinates)object.deepCopy());
        }
        if ((object = targetParameters.gettruePmRA()) != null) {
            fieldSource.setPMRA((AngularVelocity)object.deepCopy());
        }
        if ((object = targetParameters.gettruePmDec()) != null) {
            fieldSource.setPMDec((AngularVelocity)object.deepCopy());
        }
        if ((object = targetParameters.gettrueParallax()) != null) {
            fieldSource.setParallax((Angle)object.deepCopy());
        }
        fieldSource.setNonSiderealMotion(targetParameters.gettrueNonSiderealMotion());
        String string = targetParameters.getSolarSystemObject();
        if (string != null) {
            fieldSource.setSolarSystemObject(string);
            if (fieldSource.gettrueSourceName().equals("")) {
                fieldSource.setSourceName(string);
            }
        }
        if ((string = targetParameters.gettrueSourceEphemeris()) != null) {
            fieldSource.setSourceEphemeris(string);
            if (fieldSource.gettrueSourceName().equals("")) {
                fieldSource.setSourceName("Ephemeris Object");
            }
        }
        if ((object = targetParameters.gettrueSourceVelocity()) != null) {
            fieldSource.setSourceVelocity((Velocity)object.deepCopy());
        }
        if (fieldSource.getSourceVelocity().getReferenceSystem() == Velocity.REFERENCESYSTEM_HEL) {
            fieldSource.getSourceVelocity().setReferenceSystem(Velocity.REFERENCESYSTEM_BAR);
        }
        if (this.scienceGoal.gettrueSpectralSetupParameters().isSingleContinuum() && this.scienceGoal.gettrueSpectralSetupParameters().getScienceSpectralWindow(0).getIsSkyFrequency()) {
            fieldSource.getSourceVelocity().setCenterVelocity(Speed.createSpeed((double)0.0, (String)Speed.UNIT_KM_S));
        }
        this.setupFieldPattern(targetParameters, fieldSource);
    }

    protected void setupFieldSource(CalibrationTargetParameters calibrationTargetParameters, FieldSource fieldSource) {
        fieldSource.setSourceName(calibrationTargetParameters.gettrueSourceName());
        Object object = calibrationTargetParameters.gettrueSourceCoordinates();
        if (object != null) {
            fieldSource.setSourceCoordinates((SkyCoordinates)object.deepCopy());
        }
        fieldSource.setNonSiderealMotion(calibrationTargetParameters.gettrueNonSiderealMotion());
        String string = calibrationTargetParameters.getSolarSystemObject();
        if (string != null) {
            fieldSource.setSolarSystemObject(string);
            if (fieldSource.gettrueSourceName().equals("")) {
                fieldSource.setSourceName(string);
            }
        }
        if ((object = calibrationTargetParameters.gettrueSourceVelocity()) != null) {
            fieldSource.setSourceVelocity((Velocity)object.deepCopy());
        }
    }

    protected void setupFieldPattern(TargetParameters targetParameters, FieldSource fieldSource) {
        if (targetParameters.getType() == TargetParameters.TYPE_F_MULTIPLEPOINTS) {
            PointingPattern pointingPattern = PointingPattern.createPointingPattern();
            fieldSource.setFieldPattern((FieldPattern)((Object)pointingPattern));
            this.setupPointingPattern(targetParameters, pointingPattern);
            return;
        }
        if (targetParameters.getType() == TargetParameters.TYPE_F_SINGLERECTANGLE) {
            RectanglePattern rectanglePattern = RectanglePattern.createRectanglePattern();
            fieldSource.setFieldPattern((FieldPattern)((Object)rectanglePattern));
            this.setupRectanglePattern(targetParameters, rectanglePattern);
            if (this.arrayType.equals(ControlBlock.ARRAYREQUESTED_TWELVE_M)) {
                this.setupStandardMosaic(targetParameters, fieldSource);
            }
            return;
        }
    }

    protected void setupPointingPattern(TargetParameters targetParameters, PointingPattern pointingPattern) {
        for (SinglePoint singlePoint : targetParameters.getFieldSinglePoint()) {
            SkyCoordinates skyCoordinates = singlePoint.getCentre().deepCopy();
            pointingPattern.addPhaseCenterCoordinates(skyCoordinates);
        }
    }

    protected void setupRectanglePattern(TargetParameters targetParameters, RectanglePattern rectanglePattern) {
        Rectangle rectangle = targetParameters.getFieldRectangle()[0];
        SkyCoordinates skyCoordinates = rectangle.getCentre().deepCopy();
        skyCoordinates.setSystem(targetParameters.getSourceCoordinates().getSystem());
        rectanglePattern.setPatternCenterCoordinates(skyCoordinates);
        rectanglePattern.setScanningCoordinateSystem(rectangle.getFieldCenterCoordinates().getSystem());
        rectanglePattern.setOrientation(rectangle.getPALong().deepCopy());
        UserAngle userAngle = rectangle.getSpacing().deepCopy();
        userAngle.convertToUserUnit(UserAngle.UNIT_ARCSEC);
        rectanglePattern.setOrthogonalStep(userAngle);
        rectanglePattern.getLongitudeLength().setContent(rectangle.getLong().getContentInUnits(Angle.UNIT_ARCSEC));
        rectanglePattern.getLongitudeLength().setUnit(Angle.UNIT_ARCSEC);
        rectanglePattern.getLatitudeLength().setContent(rectangle.getShort().getContentInUnits(Angle.UNIT_ARCSEC));
        rectanglePattern.getLatitudeLength().setUnit(Angle.UNIT_ARCSEC);
    }

    protected void setupStandardMosaic(TargetParameters targetParameters, FieldSource fieldSource) {
        RectanglePattern rectanglePattern = (RectanglePattern)((Object)fieldSource.getFieldPattern());
        rectanglePattern.setDefaultMosaicParameters();
        Rectangle rectangle = targetParameters.getFieldRectangle()[0];
        rectanglePattern.getMosaicParameters().setSpacing(rectangle.getSpacing().getContentInUnits(Angle.UNIT_ARCSEC));
        rectanglePattern.getMosaicParameters().getFrequency().setContentAndUnit((ValueUnitPair)targetParameters.getSingleFrequency());
        RectangleMosaic rectangleMosaic = new RectangleMosaic(this, rectanglePattern){

            @Override
            public boolean abortsByTooManyPointings() {
                return true;
            }
        };
        PointingPattern pointingPattern = rectangleMosaic.getPointingPattern();
        fieldSource.setFieldPattern((FieldPattern)((Object)pointingPattern));
    }

    protected void setupFillPattern(TargetParameters targetParameters, FillPattern fillPattern) throws ToBeSupportedException {
        throw new ToBeSupportedException("This feature is not supported yet.");
    }

    protected void setupCrossPattern(TargetParameters targetParameters, CrossPattern crossPattern) throws ToBeSupportedException {
        throw new ToBeSupportedException("This feature is not supported yet.");
    }

    public Queue<FieldSource> getCalibratorFieldSource(String string) {
        return this.worker.getCalibratorFieldSources(string);
    }

    public Queue<Target> getCalibratorTarget(String string) {
        return this.worker.getCalibratorTargets(string);
    }

    public ObservingGroup getTargetsObservingGroup() {
        return this.worker.getTargetsObservingGroup();
    }

    public ObservingGroup getInitialCalibrationObservingGroup() {
        return this.worker.getInitialCalibrationObservingGroup();
    }

    public Queue<Target> getTargets() {
        return this.worker.getTargets();
    }

    public Queue<Target> getScienceTargets() {
        return this.worker.getTargets();
    }

    public Queue<Target> getScienceCalTargets() {
        return this.worker.getTargets(QuerySource.INTENDEDUSE_ATMOSPHERIC);
    }

    public List<FieldSource> getTargetFieldSources() {
        return this.worker.getTargetFieldSources();
    }
}

