/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.specialsb;

import alma.acs.entityutil.EntityDeserializer;
import alma.acs.entityutil.EntityException;
import alma.acs.entityutil.EntitySerializer;
import alma.entities.commonentity.EntityT;
import alma.entity.xmlbinding.schedblock.SchedBlock;
import alma.entity.xmlbinding.schedblock.SchedBlockEntityT;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.ReservationParameters;
import alma.obsprep.bo.schedblock.TemporalConstraints;
import alma.obsprep.ot.persistence.Apdm_to_BO;
import alma.obsprep.services.specialsb.ISpecialProjectBuilder;
import alma.obsprep.services.specialsb.ISpecialSchedBlockBuilder;
import alma.obsprep.services.specialsb.SpecialProjectBuilder;
import alma.valuetypes.Time;
import alma.xmlentity.XmlEntityStruct;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class SpecialSchedBlockBuilder
implements ISpecialSchedBlockBuilder {
    private Logger log;
    private alma.obsprep.bo.schedblock.SchedBlock bo;

    protected SpecialSchedBlockBuilder(Logger logger, ISpecialProjectBuilder iSpecialProjectBuilder) {
        this.log = logger;
        SpecialProjectBuilder specialProjectBuilder = (SpecialProjectBuilder)iSpecialProjectBuilder;
        this.createAsEmpty(specialProjectBuilder.getBo());
    }

    protected SpecialSchedBlockBuilder(Logger logger, XmlEntityStruct xmlEntityStruct) throws MarshalException, ValidationException, EntityException, UnknownEntityException {
        this.log = logger;
        this.materialize(xmlEntityStruct);
    }

    protected SpecialSchedBlockBuilder(Logger logger, alma.obsprep.bo.schedblock.SchedBlock schedBlock) {
        this.log = logger;
        this.setBo(schedBlock);
    }

    protected alma.obsprep.bo.schedblock.SchedBlock getBo() {
        return this.bo;
    }

    private void setBo(alma.obsprep.bo.schedblock.SchedBlock schedBlock) {
        this.bo = schedBlock;
    }

    public boolean isStandardMode() {
        return this.bo.getStandardMode();
    }

    public void setStandardMode(boolean bl) {
        this.bo.setStandardMode(bl);
    }

    public String getModeType() {
        return this.bo.getModeType();
    }

    public void setModeType(String string) {
        this.bo.setModeType(string);
    }

    public String getModeName() {
        return this.bo.getModeName();
    }

    public void setModeName(String string) {
        this.bo.setModeName(string);
    }

    public String getStartTime() {
        return this.bo.getTemporalConstraints()[0].getStartTime();
    }

    public void setStartTime(String string) {
        this.bo.getTemporalConstraints()[0].setStartTime(string);
    }

    public String getEndTime() {
        return this.bo.getTemporalConstraints()[0].getEndTime();
    }

    public void setEndTime(String string) {
        this.bo.getTemporalConstraints()[0].setEndTime(string);
    }

    public double getMarginSec() {
        return this.bo.getTemporalConstraints()[0].getAllowedMargin().getContentInUnits(Time.UNIT_S);
    }

    public void setMarginSec(double d) {
        this.bo.getTemporalConstraints()[0].setAllowedMargin(Time.createTimeSec(d));
    }

    public String getCalendarId() {
        return this.bo.getObservingParametersReservationParameters()[0].getCalendarId();
    }

    public void setCalendarId(String string) {
        this.bo.getObservingParametersReservationParameters()[0].setCalendarId(string);
    }

    public String getReqId() {
        return this.bo.getObservingParametersReservationParameters()[0].getReqId();
    }

    public void setReqId(String string) {
        this.bo.getObservingParametersReservationParameters()[0].setReqId(string);
    }

    public String getReason() {
        return this.bo.getObservingParametersReservationParameters()[0].getReason();
    }

    public void setReason(String string) {
        this.bo.getObservingParametersReservationParameters()[0].setReason(string);
    }

    public String getStaffMember() {
        return this.bo.getObservingParametersReservationParameters()[0].getStaffMember();
    }

    public void setStaffMember(String string) {
        this.bo.getObservingParametersReservationParameters()[0].setStaffMember(string);
    }

    public String[] getResourceList() {
        return this.bo.getObservingParametersReservationParameters()[0].getResourceList();
    }

    public void setResourceList(String[] stringArray) {
        this.bo.getObservingParametersReservationParameters()[0].setResourceList(stringArray);
    }

    public String getDescription() {
        return this.bo.getObservingParametersReservationParameters()[0].getDescription();
    }

    public void setDescription(String string) {
        this.bo.getObservingParametersReservationParameters()[0].setDescription(string);
    }

    public String getSummary() {
        return this.bo.getObservingParametersReservationParameters()[0].getSummary();
    }

    public void setSummary(String string) {
        this.bo.getObservingParametersReservationParameters()[0].setSummary(string);
    }

    private void createAsEmpty(ObsProject obsProject) {
        alma.obsprep.bo.schedblock.SchedBlock schedBlock = alma.obsprep.bo.schedblock.SchedBlock.createSchedBlock();
        TemporalConstraints temporalConstraints = TemporalConstraints.createTemporalConstraints();
        schedBlock.addTemporalConstraints(temporalConstraints);
        ReservationParameters reservationParameters = ReservationParameters.createReservationParameters();
        schedBlock.setObservingParameters((ObservingParameters[])new ReservationParameters[]{reservationParameters});
        schedBlock.setObsProject(obsProject);
        this.setBo(schedBlock);
    }

    public XmlEntityStruct serialize() throws EntityException {
        SchedBlock schedBlock = this.bo.getCastorObject();
        SchedBlockEntityT schedBlockEntityT = schedBlock.getSchedBlockEntity();
        schedBlockEntityT.setDocumentVersion("1");
        schedBlockEntityT.setSchemaVersion("1");
        EntitySerializer entitySerializer = EntitySerializer.getEntitySerializer((Logger)this.log);
        XmlEntityStruct xmlEntityStruct = entitySerializer.serializeEntity((Object)schedBlock, (EntityT)schedBlockEntityT);
        return xmlEntityStruct;
    }

    private void materialize(XmlEntityStruct xmlEntityStruct) throws MarshalException, ValidationException, EntityException, UnknownEntityException {
        EntityDeserializer entityDeserializer = EntityDeserializer.getEntityDeserializer((Logger)this.log);
        SchedBlock schedBlock = (SchedBlock)entityDeserializer.deserializeEntity(xmlEntityStruct, SchedBlock.class);
        List<SchedBlock> list = Collections.singletonList(schedBlock);
        Apdm_to_BO.BoBundle boBundle = Apdm_to_BO.getInstance().adopt(null, null, null, null, list);
        this.setBo(boBundle.boSchedblocks.get(0));
    }
}

