/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproposal.JointProposal;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.services.summaryfeedback.CompleteProposalExporter;
import alma.obsprep.services.summaryfeedback.CompleteProposalPrintable;
import alma.obsprep.services.summaryfeedback.ExportableFeedback;
import alma.obsprep.services.summaryfeedback.FeedbackSummary;
import alma.obsprep.services.summaryfeedback.FeedbackSummaryJointProposal;
import alma.obsprep.services.summaryfeedback.FeedbackSummaryObsProposal;
import alma.obsprep.services.summaryfeedback.FeedbackSummarySgCollection;
import alma.obsprep.services.summaryfeedback.JointProposalSummaryView;
import alma.obsprep.services.summaryfeedback.ObsProposalScienceGoalNavigator;
import alma.obsprep.services.summaryfeedback.PdfExporter;
import alma.obsprep.services.summaryfeedback.ProposalSummaryView;
import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryView;
import alma.obsprep.services.summaryfeedback.SummaryDocument;
import java.awt.print.Printable;

public class FeedbackSummaryObsProject
extends FeedbackSummary
implements ExportableFeedback {
    private FeedbackSummaryObsProposal proposalSummary;
    private FeedbackSummaryJointProposal jointProposalSummary;
    private FeedbackSummarySgCollection allScienceGoalsSummary;
    private ObsProposal obsProposal;
    private ObsProposalScienceGoalNavigator obsProposalScienceGoalNavigator;

    public FeedbackSummaryObsProject(ObsProject obsProject) {
        if (obsProject == null) {
            Log.logger((Object)this).warning("Project must not be null");
            return;
        }
        this.setUserObject((BusinessObject)obsProject);
        try {
            this.obsProposal = obsProject.getObsProposal();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger((Object)this).warning("Can not get proposal : " + unknownEntityException.getMessage());
            return;
        }
        assert (this.obsProposal != null);
        this.obsProposalScienceGoalNavigator = new ObsProposalScienceGoalNavigator(this.obsProposal, true);
        this.proposalSummary = new FeedbackSummaryObsProposal(this.obsProposal);
        this.jointProposalSummary = new FeedbackSummaryJointProposal(this.obsProposal);
        this.allScienceGoalsSummary = new FeedbackSummarySgCollection(this.obsProposal, this.obsProposalScienceGoalNavigator);
        this.setView(this.proposalSummary.view);
    }

    public Object getCurrentObject() {
        if (this.view == this.proposalSummary.view) {
            return this.obsProposal;
        }
        if (this.view == this.jointProposalSummary.view) {
            return this.obsProposal.getJointProposal();
        }
        SummaryDocument summaryDocument = (SummaryDocument)this.view.getModel().getDocument();
        return summaryDocument == null ? null : summaryDocument.getUserObject();
    }

    @Override
    public boolean hasNext() {
        if (this.obsProposal == null) {
            return false;
        }
        Object object = this.getCurrentObject();
        if (object == null) {
            return false;
        }
        if (object == this.obsProposal) {
            JointProposal jointProposal = this.obsProposal.getJointProposal();
            if (jointProposal != null && jointProposal.getIsJointProposal()) {
                return true;
            }
            return this.obsProposalScienceGoalNavigator.getScienceGoalCount() > 0;
        }
        if (object instanceof JointProposal) {
            return this.obsProposalScienceGoalNavigator.getScienceGoalCount() > 0;
        }
        if (object instanceof ScienceGoal) {
            ScienceGoal scienceGoal = (ScienceGoal)object;
            int n = this.obsProposalScienceGoalNavigator.indexOf(scienceGoal);
            if (n == -1) {
                return false;
            }
            return n < this.obsProposalScienceGoalNavigator.getScienceGoalCount() - 1;
        }
        Log.logger((Object)this).warning("Unexpected object : " + String.valueOf(object));
        return false;
    }

    @Override
    public boolean hasPrev() {
        if (this.obsProposal == null) {
            return false;
        }
        Object object = this.getCurrentObject();
        if (object == null) {
            return false;
        }
        if (object == this.obsProposal) {
            return false;
        }
        if (object instanceof JointProposal) {
            return true;
        }
        if (object instanceof ScienceGoal) {
            return true;
        }
        Log.logger((Object)this).warning("Unexpected object : " + String.valueOf(object));
        return false;
    }

    @Override
    public void showNext() {
        if (!this.hasNext() || this.obsProposal == null) {
            return;
        }
        Object object = this.getCurrentObject();
        if (object == this.obsProposal) {
            JointProposal jointProposal = this.obsProposal.getJointProposal();
            if (jointProposal != null && jointProposal.getIsJointProposal()) {
                this.setView(this.jointProposalSummary.view);
                this.jointProposalSummary.buildPage(this.obsProposal);
            } else {
                this.setView(this.allScienceGoalsSummary.view);
                this.allScienceGoalsSummary.buildPage(this.obsProposalScienceGoalNavigator.getScienceGoal(0));
            }
        } else if (object instanceof JointProposal) {
            this.setView(this.allScienceGoalsSummary.view);
            this.allScienceGoalsSummary.buildPage(this.obsProposalScienceGoalNavigator.getScienceGoal(0));
        } else {
            int n = this.obsProposalScienceGoalNavigator.indexOf((ScienceGoal)object);
            this.allScienceGoalsSummary.buildPage(this.obsProposalScienceGoalNavigator.getScienceGoal(n + 1));
        }
    }

    @Override
    public void showPrev() {
        if (!this.hasPrev() || this.obsProposal == null) {
            return;
        }
        Object object = this.getCurrentObject();
        if (object instanceof ScienceGoal) {
            int n = this.obsProposalScienceGoalNavigator.indexOf((ScienceGoal)object);
            if (n == 0) {
                JointProposal jointProposal = this.obsProposal.getJointProposal();
                if (jointProposal != null && jointProposal.getIsJointProposal()) {
                    this.jointProposalSummary.buildPage(this.obsProposal);
                    this.setView(this.jointProposalSummary.view);
                } else {
                    this.proposalSummary.buildPage(this.obsProposal);
                    this.setView(this.proposalSummary.view);
                }
            } else {
                this.setView(this.allScienceGoalsSummary.view);
                this.allScienceGoalsSummary.buildPage(this.obsProposalScienceGoalNavigator.getScienceGoal(n - 1));
            }
        } else if (object instanceof JointProposal) {
            this.proposalSummary.buildPage(this.obsProposal);
            this.setView(this.proposalSummary.view);
        }
    }

    @Override
    public Printable getAllPagePrintable() {
        return new CompleteProposalPrintable(this.obsProposal);
    }

    @Override
    public PdfExporter getPdfExporter() {
        ProposalSummaryView proposalSummaryView = (ProposalSummaryView)this.proposalSummary.view.createOfflinePDFView();
        JointProposalSummaryView jointProposalSummaryView = (JointProposalSummaryView)this.jointProposalSummary.view.createOfflinePDFView();
        ScienceGoalSummaryView scienceGoalSummaryView = (ScienceGoalSummaryView)this.allScienceGoalsSummary.view.createOfflinePDFView();
        CompleteProposalExporter completeProposalExporter = new CompleteProposalExporter(proposalSummaryView, jointProposalSummaryView, scienceGoalSummaryView);
        completeProposalExporter.setObsProposal(this.obsProposal);
        return completeProposalExporter;
    }
}

