/*
 * Decompiled with CFR 0.152.
 */
package alma.common.sourcecatalog;

import alma.common.calibratorCatalogue.calQueryParameters.CalQueryParameters;
import alma.common.sourcecatalog.SourceCatalogQueryParameters;
import java.util.Calendar;
import java.util.Date;

public class CatalogQueryParameters
extends CalQueryParameters
implements SourceCatalogQueryParameters {
    private static final long serialVersionUID = -7323905482425945748L;
    public static final int UNDEFINED = -999;
    private Integer maxSources = 100;
    private String sortBy;
    private String name = "";
    private boolean sortAscending = true;
    private boolean hasEarliestObservation = false;
    private boolean hasLatestObservation = false;
    private boolean hasName = false;
    private boolean hasSortBy = false;

    @Override
    public Integer getMaxSources() {
        return this.maxSources;
    }

    @Override
    public void setMaxSources(Integer max) {
        if (max != null) {
            this.maxSources = max;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.hasName = this.name != null;
    }

    @Override
    public boolean hasName() {
        return this.hasName;
    }

    @Override
    public void deleteName() {
        this.setName(null);
    }

    @Override
    public String getSortBy() {
        return this.sortBy;
    }

    @Override
    public void setSortBy(String field) {
        this.sortBy = field;
        this.hasSortBy = field != null;
    }

    @Override
    public boolean hasSortBy() {
        return this.hasSortBy;
    }

    @Override
    public void deleteSortBy() {
        this.setSortBy(null);
    }

    @Override
    public void setSortAscending(boolean state) {
        this.sortAscending = state;
    }

    @Override
    public boolean getSortAscending() {
        return this.sortAscending;
    }

    @Override
    public boolean hasEarliestObservation() {
        return this.hasEarliestObservation;
    }

    @Override
    public boolean hasLatestObservation() {
        return this.hasLatestObservation;
    }

    public void setEarliestObservation(Calendar earliestObservation) {
        if (earliestObservation != null) {
            this.setEarliestObservation(earliestObservation.getTime());
        } else {
            super.setEarliestObservation(null);
            this.hasEarliestObservation = false;
        }
    }

    @Override
    public void setEarliestObservation(Date earliestObservation) {
        super.setEarliestObservation(earliestObservation);
        this.hasEarliestObservation = earliestObservation != null;
    }

    @Override
    public void setLatestObservation(Date latestObservation) {
        super.setLatestObservation(latestObservation);
        this.hasLatestObservation = latestObservation != null;
    }

    public void setLatestObservation(Calendar latestObservation) {
        if (latestObservation != null) {
            this.setLatestObservation(latestObservation.getTime());
        } else {
            super.setLatestObservation(null);
            this.hasLatestObservation = false;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CalQueryParams: ");
        sb.append((String)(this.hasName() ? "  Name: " + this.getName() : ""));
        sb.append((String)(this.hasRightAscension() ? "  RA(mas): " + this.getRightAscension() : ""));
        sb.append((String)(this.hasDeclination() ? "  Dec(mas): " + this.getDeclination() : ""));
        sb.append((String)(this.hasRadius() ? "  Radius: " + this.getRadius() : ""));
        sb.append((String)(this.hasMinFrequency() ? "  MinFreq: " + this.getMinFrequency() : ""));
        sb.append((String)(this.hasMaxFrequency() ? "  MaxFreq: " + this.getMaxFrequency() : ""));
        sb.append((String)(this.hasMinFlux() ? "  MinFlux: " + this.getMinFlux() : ""));
        sb.append((String)(this.hasMaxFlux() ? "  MaxFlux: " + this.getMaxFlux() : ""));
        sb.append((String)(this.hasEarliestObservation() ? "  EarliestObs: " + String.valueOf(this.getEarliestObservation()) : ""));
        sb.append((String)(this.hasLatestObservation() ? "  LatestObs: " + String.valueOf(this.getLatestObservation()) : ""));
        sb.append("  MaxSources: " + this.getMaxSources());
        sb.append("  Sort By: " + this.getSortBy());
        return sb.toString();
    }
}

