/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import org.exolab.castor.builder.types.AbstractRangeFacet;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public final class XSDouble
extends AbstractRangeFacet {
    public static final String NAME = "double";
    public static final short TYPE = 15;
    public static final String MIN_VALUE = Double.toString(-1.7976931348623157E308);
    public static final String MAX_VALUE = Double.toString(Double.MAX_VALUE);
    public static final String INFINITY_VALUE = "Double.POSITIVE_INFINITY";
    public static final String NEGATIVE_INFINITY_VALUE = "Double.NEGATIVE_INFINITY";
    private final boolean _asWrapper;
    private final JType _jType;

    public XSDouble() {
        this(false);
    }

    public XSDouble(boolean asWrapper) {
        this._asWrapper = asWrapper;
        this._jType = this._asWrapper ? new JClass("java.lang.Double") : JType.DOUBLE;
        this.setMinInclusive(MIN_VALUE);
        this.setMaxInclusive(MAX_VALUE);
        this.setPositiveInfinity(INFINITY_VALUE);
        this.setNegativeInfinity(NEGATIVE_INFINITY_VALUE);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public short getType() {
        return 15;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public boolean isDateTime() {
        return false;
    }

    @Override
    public JType getJType() {
        return this._jType;
    }

    @Override
    public String newInstanceCode() {
        return "new java.lang.Double(0.0);";
    }

    @Override
    public String createToJavaObjectCode(String variableName) {
        if (this._asWrapper) {
            return variableName;
        }
        return "new java.lang.Double(" + variableName + ")";
    }

    @Override
    public String createFromJavaObjectCode(String variableName) {
        if (this._asWrapper) {
            return "((java.lang.Double) " + variableName + ")";
        }
        return "((java.lang.Double) " + variableName + ").doubleValue()";
    }

    @Override
    public void validationCode(JSourceCode jsc, String fixedValue, String validatorInstanceName) {
        jsc.add("org.exolab.castor.xml.validators.DoubleValidator typeValidator;\ntypeValidator = new org.exolab.castor.xml.validators.DoubleValidator();\n{0}.setValidator(typeValidator);", validatorInstanceName);
        if (fixedValue != null) {
            jsc.add("typeValidator.setFixed(" + fixedValue + ");");
        }
        this.codePatternFacet(jsc, "typeValidator");
        this.codeWhiteSpaceFacet(jsc, "typeValidator");
        if (this.getMinExclusive() != null) {
            jsc.add("typeValidator.setMinExclusive(" + this.getMinExclusive() + ");");
        } else if (this.getMinInclusive() != null) {
            jsc.add("typeValidator.setMinInclusive(" + this.getMinInclusive() + ");");
        }
        if (this.getMaxExclusive() != null) {
            jsc.add("typeValidator.setMaxExclusive(" + this.getMaxExclusive() + ");");
        } else if (this.getMaxInclusive() != null) {
            jsc.add("typeValidator.setMaxInclusive(" + this.getMaxInclusive() + ");");
        }
        if (this.getPositiveInfinity() != null) {
            jsc.add("typeValidator.setPositiveInfinity(java.lang." + this.getPositiveInfinity() + ");");
        }
        if (this.getNegativeInfinity() != null) {
            jsc.add("typeValidator.setNegativeInfinity(java.lang." + this.getNegativeInfinity() + ");");
        }
    }

    @Override
    public String createDefaultValueWithString(String variableName) {
        if (this._asWrapper) {
            return "java.lang.Double.valueOf(" + variableName + ")";
        }
        return "java.lang.Double.valueOf(" + variableName + ").doubleValue()";
    }
}

