/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.commandcenter.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import si.ijs.maci.ClientInfo;
import si.ijs.maci.ComponentInfo;
import si.ijs.maci.ContainerInfo;

public class MaciInfo
extends DefaultTreeModel {
    volatile List<ComponentInfo> components = Collections.EMPTY_LIST;
    volatile List<ContainerInfo> containers = Collections.EMPTY_LIST;
    volatile List<ClientInfo> clientApps = Collections.EMPTY_LIST;
    protected final SortingTreeNode managerNode = this.createNode("Manager");
    protected final SortingTreeNode containerNode;
    protected final SortingTreeNode clientNode;
    protected final SortingTreeNode componentNode;

    public List<ContainerInfo> getContainers() {
        List<ContainerInfo> current = this.containers;
        ArrayList<ContainerInfo> ret = new ArrayList<ContainerInfo>(current);
        return ret;
    }

    public ContainerInfo getContainer(String name) {
        List<ContainerInfo> current = this.containers;
        for (ContainerInfo info : current) {
            if (!info.name.equals(name)) continue;
            return info;
        }
        return null;
    }

    public ContainerInfo getContainer(int handle) {
        List<ContainerInfo> current = this.containers;
        for (ContainerInfo info : current) {
            if (info.h != handle) continue;
            return info;
        }
        return null;
    }

    public List<ClientInfo> getClients() {
        List<ClientInfo> current = this.clientApps;
        ArrayList<ClientInfo> ret = new ArrayList<ClientInfo>(current);
        return ret;
    }

    public ClientInfo getClient(String name) {
        List<ClientInfo> current = this.clientApps;
        for (ClientInfo info : current) {
            if (!info.name.equals(name)) continue;
            return info;
        }
        return null;
    }

    public ClientInfo getClient(int handle) {
        List<ClientInfo> current = this.clientApps;
        for (ClientInfo info : current) {
            if (info.h != handle) continue;
            return info;
        }
        return null;
    }

    public List<ComponentInfo> getComponents() {
        List<ComponentInfo> current = this.components;
        ArrayList<ComponentInfo> ret = new ArrayList<ComponentInfo>(current);
        return ret;
    }

    public ComponentInfo getComponent(String name) {
        List<ComponentInfo> current = this.components;
        for (ComponentInfo info : current) {
            if (!info.name.equals(name)) continue;
            return info;
        }
        return null;
    }

    public ComponentInfo getComponent(int handle) {
        List<ComponentInfo> current = this.components;
        for (ComponentInfo info : current) {
            if (info.h != handle) continue;
            return info;
        }
        return null;
    }

    public List<ComponentInfo> getStartedComponents() {
        List<ComponentInfo> current = this.components;
        ArrayList<ComponentInfo> ret = new ArrayList<ComponentInfo>(current.size());
        for (ComponentInfo info : current) {
            if (info.h == 0) continue;
            ret.add(info);
        }
        return ret;
    }

    protected MaciInfo() {
        super(null);
        this.root = this.managerNode;
        this.containerNode = this.createNode(new FolderInfo("Containers"));
        this.managerNode.add(this.containerNode);
        this.clientNode = this.createNode(new FolderInfo("Client Applications"));
        this.managerNode.add(this.clientNode);
        this.componentNode = this.createNode(new FolderInfo("Components"));
        this.managerNode.add(this.componentNode);
    }

    protected void setContents(List<ComponentInfo> newComponents, List<ContainerInfo> newContainers, List<ClientInfo> newClientApps, Map<Object, String> auxiliary) {
        SortingTreeNode n;
        this.components = newComponents;
        this.containers = newContainers;
        this.clientApps = newClientApps;
        this.componentNode.removeAllChildren();
        for (ComponentInfo comp : newComponents) {
            n = this.createNode(comp);
            this.addInfoNodes(n, auxiliary);
            this.componentNode.add(n);
        }
        this.containerNode.removeAllChildren();
        for (ContainerInfo cont : newContainers) {
            n = this.createNode(cont);
            this.addInfoNodes(n, auxiliary);
            for (ComponentInfo comp : newComponents) {
                if (comp.container != cont.h || comp.h == 0) continue;
                n.add(this.createNode(comp));
            }
            this.containerNode.add(n);
        }
        this.clientNode.removeAllChildren();
        for (ClientInfo client : newClientApps) {
            n = this.createNode(client);
            this.addInfoNodes(n, auxiliary);
            this.clientNode.add(n);
        }
        this.componentNode.sortChildrenByName();
        this.containerNode.sortChildrenByName();
        this.clientNode.sortChildrenByName();
        this.nodeStructureChanged(this.managerNode);
    }

    protected SortingTreeNode createNode(Object info) {
        SortingTreeNode ret = new SortingTreeNode();
        if (info instanceof ContainerInfo) {
            ret.setUserObject(info);
            ContainerInfo casted = (ContainerInfo)info;
            if (casted.h != 0) {
                ret.representedHandles = new int[]{casted.h};
            }
        } else if (info instanceof ClientInfo) {
            ret.setUserObject(info);
            ClientInfo casted = (ClientInfo)info;
            if (casted.h != 0) {
                ret.representedHandles = new int[]{casted.h};
            }
        } else if (info instanceof ComponentInfo) {
            ret.setUserObject(info);
            ComponentInfo casted = (ComponentInfo)info;
            if (casted.h != 0) {
                ret.representedHandles = new int[]{casted.h};
            }
        } else if (info instanceof InfoDetail) {
            InfoDetail casted = (InfoDetail)info;
            ret.setUserObject(info);
            ret.representedHandles = casted.representedHandles;
        } else if (info instanceof FolderInfo) {
            ret.setUserObject(info);
        } else {
            ret.setUserObject(info);
            if ("Manager".equals(info)) {
                ret.representedHandles = new int[]{0x5000000};
            }
        }
        return ret;
    }

    protected void addInfoNodes(SortingTreeNode node, Map<Object, String> auxiliary) {
        Object info = node.getUserObject();
        int infokey = System.identityHashCode(info);
        if (info instanceof ContainerInfo) {
            node.add(this.createNode(new InfoDetail("location", auxiliary.get(infokey + ".location"))));
        } else if (info instanceof ClientInfo) {
            ClientInfo casted = (ClientInfo)info;
            node.add(this.createNode(new InfoDetail("location", auxiliary.get(infokey + ".location"))));
            node.add(this.createNode(new InfoDetail("components", casted.components, true)));
            node.add(this.createNode(new InfoDetail("access", casted.access, false)));
            node.add(this.createNode(new InfoDetail("reference", casted.reference)));
        } else if (info instanceof ComponentInfo) {
            ComponentInfo casted = (ComponentInfo)info;
            node.add(this.createNode(new InfoDetail("clients", casted.clients, true)));
            node.add(this.createNode(new InfoDetail("container", casted.container, true)));
            node.add(this.createNode(new InfoDetail("container_name", casted.container_name)));
            node.add(this.createNode(new InfoDetail("access", casted.access, false)));
            node.add(this.createNode(new InfoDetail("reference", casted.reference)));
            node.add(this.createNode(new InfoDetail("interfaces", casted.interfaces)));
            node.add(this.createNode(new InfoDetail("type", casted.type)));
            node.add(this.createNode(new InfoDetail("code", casted.code)));
        }
    }

    public static class SortingTreeNode
    extends DefaultMutableTreeNode {
        public int[] representedHandles = new int[0];
        public boolean filtered;
        static Comparator<Object> byName = new Comparator<Object>(){

            @Override
            public int compare(Object a, Object b) {
                String valA = ((SortingTreeNode)a).infoName();
                String valB = ((SortingTreeNode)b).infoName();
                return valA.compareTo(valB);
            }
        };

        protected SortingTreeNode() {
        }

        public SortingTreeNode(Object userObject) {
            super(userObject);
        }

        public boolean represents(int h) {
            for (int i = 0; i < this.representedHandles.length; ++i) {
                if (this.representedHandles[i] != h) continue;
                return true;
            }
            return false;
        }

        @Override
        public SortingTreeNode clone() {
            SortingTreeNode ret = (SortingTreeNode)super.clone();
            ret.representedHandles = this.representedHandles;
            return ret;
        }

        public Iterable<SortingTreeNode> childrens() {
            final Enumeration<TreeNode> orig = this.children();
            return new Iterable<SortingTreeNode>(){

                @Override
                public Iterator<SortingTreeNode> iterator() {
                    return new Iterator<SortingTreeNode>(){

                        @Override
                        public boolean hasNext() {
                            return orig.hasMoreElements();
                        }

                        @Override
                        public SortingTreeNode next() {
                            return (SortingTreeNode)orig.nextElement();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sortChildrenByName() {
            if (this.children != null) {
                Vector vector = this.children;
                synchronized (vector) {
                    Collections.sort(this.children, byName);
                }
            }
        }

        protected String infoName() {
            if (this.userObject instanceof ContainerInfo) {
                return ((ContainerInfo)this.userObject).name;
            }
            if (this.userObject instanceof ClientInfo) {
                return ((ClientInfo)this.userObject).name;
            }
            if (this.userObject instanceof ComponentInfo) {
                return ((ComponentInfo)this.userObject).name;
            }
            return "";
        }

        public boolean equals(SortingTreeNode other) {
            Object otherObject = other.getUserObject();
            if (this.userObject == null || otherObject == null) {
                return false;
            }
            if (this.userObject.getClass() != otherObject.getClass()) {
                return false;
            }
            if (this.userObject instanceof ContainerInfo) {
                return ((ContainerInfo)this.userObject).name.equals(((ContainerInfo)otherObject).name);
            }
            if (this.userObject instanceof ClientInfo) {
                return ((ClientInfo)this.userObject).h == ((ClientInfo)otherObject).h;
            }
            if (this.userObject instanceof ComponentInfo) {
                return ((ComponentInfo)this.userObject).name.equals(((ComponentInfo)otherObject).name);
            }
            return false;
        }
    }

    public static class FolderInfo {
        public String name;
        public String filter;

        public boolean hasFilter() {
            return this.filter != null && !this.filter.isEmpty();
        }

        protected FolderInfo(String name) {
            this.name = name;
        }

        public String toString() {
            return "Folder \"" + this.name + "\"";
        }
    }

    public static class InfoDetail {
        public String key;
        public String value;
        public int[] representedHandles = new int[0];

        protected InfoDetail(String key, String[] value) {
            if (value.length == 0) {
                this.value = "none";
            } else {
                StringBuffer list = new StringBuffer();
                for (int i = 0; i < value.length; ++i) {
                    list.append(String.valueOf(value[i])).append(",");
                }
                list.setLength(list.length() - ",".length());
                this.value = list.toString();
            }
            this.key = key;
        }

        protected InfoDetail(String key, int[] value, boolean intRepresentsHandle) {
            StringBuffer list = new StringBuffer();
            if (value.length == 0) {
                list.append("none");
            } else {
                for (int i = 0; i < value.length; ++i) {
                    list.append(String.valueOf(value[i])).append(",");
                }
                list.setLength(list.length() - ",".length());
            }
            this.key = key;
            this.value = list.toString();
            if (intRepresentsHandle) {
                this.representedHandles = value;
            }
        }

        protected InfoDetail(String key, Object value) {
            this.key = key;
            this.value = String.valueOf(value);
        }

        protected InfoDetail(String key, int value, boolean intRepresentsHandle) {
            this.key = key;
            this.value = String.valueOf(value);
            if (intRepresentsHandle && value != 0) {
                this.representedHandles = new int[]{value};
            }
        }

        public String toString() {
            return "Detail \"" + this.key + "=" + this.value + "\"";
        }
    }
}

