/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import uk.ac.starlink.util.DataSource;

public class URLDataSource
extends DataSource {
    private URL url;

    public URLDataSource(URL url) {
        this.url = url;
        this.setName(url.toString());
        this.setPosition(url.getRef());
    }

    protected InputStream getRawInputStream() throws IOException {
        int code;
        URLConnection connection = this.url.openConnection();
        if (connection instanceof HttpURLConnection && ((code = ((HttpURLConnection)connection).getResponseCode()) == 301 || code == 302)) {
            String newloc = connection.getHeaderField("Location");
            URL newurl = new URL(newloc);
            connection = newurl.openConnection();
        }
        InputStream strm = connection.getInputStream();
        return new FilterInputStream(strm){

            public boolean markSupported() {
                return false;
            }
        };
    }

    public URL getURL() {
        return this.url;
    }
}

