<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:op="Alma/ObsPrep/ObsProject">

<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>

<!-- Be careful - this matches ALL attributes called datamodelVersion
     'cause I couldn't figure out how to address ObsProjectEntity -->
<xsl:template match="@datamodelVersion">
  <xsl:attribute name="datamodelVersion">1.59</xsl:attribute>
  <xsl:comment>Converted to 1.59 by ObsProposal20-30.xslt</xsl:comment>
</xsl:template>

<!-- Rename array names -->
<xsl:template match="op:ObsUnitControl">
<ObsUnitControl>
   <xsl:choose>
      <xsl:when test="@arrayRequested = 'ALMAMain'">
         <xsl:attribute name="arrayRequested">TWELVE-M</xsl:attribute>
      </xsl:when>
      <xsl:when test="@arrayRequested = 'ACA7m'">
         <xsl:attribute name="arrayRequested">SEVEN-M</xsl:attribute>
      </xsl:when>
      <xsl:when test="@arrayRequested = 'ACA12m'">
         <xsl:attribute name="arrayRequested">TP-Array</xsl:attribute>
      </xsl:when>
      <xsl:when test="@arrayRequested = 'ACA12m+7m'">
         <xsl:attribute name="arrayRequested">ACA</xsl:attribute>
      </xsl:when>
      <xsl:otherwise>
         <xsl:attribute name="arrayRequested">Unknown</xsl:attribute>
      </xsl:otherwise>
   </xsl:choose>
   <xsl:apply-templates/>
</ObsUnitControl>
</xsl:template>

<!-- Identity stylesheet - simply copies everything -->
<!-- See Pg. 202 XSLT Cookbook by Sal Mangano, O'Reilly -->
<xsl:template match="node() | @*">
  <xsl:copy>
    <xsl:apply-templates select="@* | node()"/>
  </xsl:copy>
</xsl:template>
</xsl:stylesheet>
