<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:id="Alma/ObsPrep/SchedBlock"
                xmlns:op="Alma/ObsPrep/ObsProject"
		xmlns:vt="Alma/ValueTypes">
		
<!-- Major change for this script is the reworking of the Correlator configuration
	to allow for the ACA Correlator.  Since old projects did not support the ACA corr,
	then assume ALL correlator configurations are BL ones - this simplifies things.
	(But it does leave a loophole in that if someone had specified ACA as arrayRequested
	then the SB will become invalid - leave this possibility to be sorted by the user, it is
	unlikely and really non problematic in any case
-->

<!--
     Notice that I've put 
                 xmlns:id="Alma/ObsPrep/SchedBlock"
     in as a namespace and used it to match against. This is the 
     same URI (Alma/ObsPrep/SchedBlock) as the default namespace in the
     Alma documents. For an idea of why this is necessary, see 
     http://www.topxml.com/people/bosley/defaultns.asp
 -->
<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>

<!-- Be careful - this matches ALL attributes called datamodelVersion
     'cause I couldn't figure out how to address ObsProjectEntity -->
<xsl:template match="id:SchedBlockEntity/@datamodelVersion">
  <xsl:attribute name="datamodelVersion">1.72</xsl:attribute>
  <xsl:comment>Converted to 1.72 by SchedBlock40-50.xslt</xsl:comment>
</xsl:template>


<!-- Identity stylesheet - simply copies everything -->
<!-- See Pg. 202 XSLT Cookbook by Sal Mangano, O'Reilly -->
<xsl:template match="node() | @*">
  <xsl:copy>
    <xsl:apply-templates select="@* | node()"/>
  </xsl:copy>
</xsl:template>

<!-- All integrationTimes need to switch from "s" to "sec" - this was in an earlier change, 
	but seems as though some may have crept through somehow -->
<xsl:template match="id:integrationTime">
   <xsl:choose>
      <xsl:when test="./@unit = 's'">
         <integrationTime>
            <xsl:attribute name="unit">sec</xsl:attribute>
            <xsl:value-of select="."/>
         </integrationTime> 
      </xsl:when>
      <xsl:otherwise>
          <integrationTime>
            <xsl:attribute name="unit"><xsl:value-of select="@unit"/></xsl:attribute>
            <xsl:value-of select="."/>
         </integrationTime> 
      </xsl:otherwise>
   </xsl:choose>
</xsl:template>

<xsl:template match="id:intTimeSource">
   <xsl:choose>
      <xsl:when test="./@unit = 's'">
         <intTimeSource>
            <xsl:attribute name="unit">sec</xsl:attribute>
            <xsl:value-of select="."/>
         </intTimeSource> 
      </xsl:when>
      <xsl:otherwise>
          <intTimeSource>
            <xsl:attribute name="unit"><xsl:value-of select="@unit"/></xsl:attribute>
            <xsl:value-of select="."/>
         </intTimeSource> 
      </xsl:otherwise>
   </xsl:choose>
</xsl:template>

<xsl:template match="vt:longitude">
   <xsl:choose>
      <xsl:when test="./@unit = 'deg'">
         <longitude>
            <xsl:attribute name="unit">degrees</xsl:attribute>
            <xsl:value-of select="."/>
         </longitude> 
      </xsl:when>
      <xsl:otherwise>
          <longitude>
            <xsl:attribute name="unit"><xsl:value-of select="@unit"/></xsl:attribute>
            <xsl:value-of select="."/>
         </longitude> 
      </xsl:otherwise>
   </xsl:choose>
</xsl:template>

<xsl:template match="vt:latitude">
   <xsl:choose>
      <xsl:when test="./@unit = 'deg'">
         <latitude>
            <xsl:attribute name="unit">degrees</xsl:attribute>
            <xsl:value-of select="."/>
         </latitude> 
      </xsl:when>
      <xsl:otherwise>
          <latitude>
            <xsl:attribute name="unit"><xsl:value-of select="@unit"/></xsl:attribute>
            <xsl:value-of select="."/>
         </latitude> 
      </xsl:otherwise>
   </xsl:choose>
</xsl:template>

<!-- ChannelAverageBands - move to be in SpectralWindow, rename to region and use (&delete) subbandIndex to 
     decide where...?? However, for now (and perhaps its good enough?) just copy the chan av bands into spec windows-->
<xsl:template match="id:ChannelAverageBands">
<ChannelAverageRegion>
   <xsl:apply-templates select="./id:startChannel"/>
   <xsl:apply-templates select="./id:numberChannels"/>
</ChannelAverageRegion>
</xsl:template>

<!-- Spectralsubbandsets, rename to BLSpectralWindow -->
<xsl:template match="id:SpectralSubbandSet">
<BLSpectralWindow>
<!--   <xsl:apply-templates/> -->
   <!-- add attribute windowFunction, value from bbc, translated to upper case -->
   <xsl:attribute name="windowFunction"><xsl:value-of select="translate(../@windowFunction,'abcdefghijklmnopqrstuvwxyz-','ABCDEFGHIJKLMNOPQRSTUVWXYZ_')"/></xsl:attribute>

   <!-- add attribute sideBand, value from bbc (only usb/lsb were allowed in old config) -->
   <xsl:choose>
      <xsl:when test="../@sideBand = 'usb'">
         <xsl:attribute name="sideBand">USB</xsl:attribute>
      </xsl:when>
      <xsl:otherwise>
         <xsl:attribute name="sideBand">LSB</xsl:attribute>
      </xsl:otherwise>
   </xsl:choose> 
  
   <xsl:choose>
     <xsl:when test="./id:tFBMode='103'">

         <!-- add attribute polnProducts -->
         <xsl:attribute name="polnProducts">XX</xsl:attribute>

         <!-- add attribute correlationBits -->
         <xsl:attribute name="correlationBits">BITS_2x2</xsl:attribute>

      </xsl:when>
      <xsl:otherwise>

         <!-- add attribute polnProducts -->
         <xsl:attribute name="polnProducts">XX</xsl:attribute>

         <!-- add attribute correlationBits (value BITS_2x2?) -->
         <xsl:attribute name="correlationBits">BITS_2x2</xsl:attribute>

      </xsl:otherwise>
   </xsl:choose>
  
   <!-- delete correlatorFraction NOTHING TO DO-->

   <!-- add element name -->
   <name>BLSW</name>
   
   <!-- in theory should decode tfbMode into bw/res/chan...  but this is a lot - treat only special cases -->
   <!-- delete tFBMode NOTHING TO DO-->

   <xsl:choose>
      <xsl:when test="./id:tFBMode='103'">
         <!-- add effectiveBandwidth  -->
         <effectiveBandwidth unit="GHz">2.000</effectiveBandwidth>
   
         <!-- add effectiveNumberOfChannels -->
         <effectiveNumberOfChannels>256</effectiveNumberOfChannels>
 
         <!-- add correlationNyquistOversampling (false) -->
         <correlationNyquistOversampling>false</correlationNyquistOversampling>
      </xsl:when>
      <xsl:otherwise>
         <!-- add effectiveBandwidth  -->
         <effectiveBandwidth unit="GHz">1.875</effectiveBandwidth>
   
         <!-- add effectiveNumberOfChannels -->
         <effectiveNumberOfChannels>7680</effectiveNumberOfChannels>
 
         <!-- add correlationNyquistOversampling (false) -->
         <correlationNyquistOversampling>false</correlationNyquistOversampling>
      </xsl:otherwise>
   </xsl:choose>
    
   <!-- delete numOverlapChannels NOTHING TO DO -->
   <!-- copy spectralAveragingFactor -->
   <xsl:apply-templates select="./id:spectralAveragingFactor"/>

   <!-- add associatedSpectralWindowNumberInPair (value?) -->
   <associatedSpectralWindowNumberInPair>1</associatedSpectralWindowNumberInPair>
   
   <!-- add useThisSpectralWindow (true) -->
   <useThisSpectralWindow>true</useThisSpectralWindow>
  
   <!-- add quantizationCorrection (value from bbc or true) -->
   <quantizationCorrection><xsl:value-of select="../id:quantizationCorrection"/></quantizationCorrection>
   
   <xsl:apply-templates select="./id:centerFrequency"/>
   
   <!-- Move ChannelAverageBands into here as ChannelAverageRegion -->
   <xsl:apply-templates select="../id:ChannelAverageBands"/>

</BLSpectralWindow>
</xsl:template>

<!-- BaseBandCOnfig, rename to BLBaseBandConfig -->
<xsl:template match="id:BaseBandConfig">
<BLBaseBandConfig>
   <!-- Change cAM value from 1 to FAST or 16 to NORMAL and make it an attribute -->
   <xsl:choose>
      <xsl:when test="./id:cAM = 1">
         <xsl:attribute name="cAM">ALMA_FAST</xsl:attribute>
      </xsl:when>
      <xsl:otherwise>
         <xsl:attribute name="cAM">ALMA_NORMAL</xsl:attribute>
      </xsl:otherwise>
   </xsl:choose> 
   
   <!-- Replace baseBandIndex with baseBandName and make an attribute (add "BB_" to the index) -->
   <xsl:attribute name="baseBandName">BB_<xsl:value-of select="./id:baseBandIndex"/></xsl:attribute>
    
   <!-- Change binMode to switchingType and make attribute -->
    <xsl:choose>
      <xsl:when test="./id:binMode = 0">
         <xsl:attribute name="switchingType">NO_SWITCHING</xsl:attribute>
      </xsl:when>
      <xsl:when test="./id:binMode = 1">  
         <xsl:attribute name="switchingType">POSITION_SWITCHING</xsl:attribute>
      </xsl:when>
      <xsl:otherwise>
         <xsl:attribute name="switchingType">FREQUENCY_SWITCHING</xsl:attribute>
      </xsl:otherwise>
   </xsl:choose> 

   <!-- rename dataProducts -->
   <xsl:attribute name="dataProducts"><xsl:value-of select="./@dataProducts"/></xsl:attribute>
   <xsl:choose>
      <xsl:when test="./@dataProducts='CROSS_ONLY_PRODUCTS'">
         <xsl:attribute name="dataProducts">CROSS_ONLY</xsl:attribute>
      </xsl:when>
     <xsl:when test="./@dataProducts='AUTO_ONLY_PRODUCTS'">
         <xsl:attribute name="dataProducts">AUTO_ONLY</xsl:attribute>
      </xsl:when>
      <xsl:otherwise>
         <xsl:attribute name="dataProducts">CROSS_AND_AUTO</xsl:attribute>
      </xsl:otherwise>
   </xsl:choose>    
   <!-- Add sideband separation mode value = ??? -->
   <xsl:attribute name="sideBandSeparationMode">NONE</xsl:attribute>
   
   <!-- change bin0duration to dwellTime -->
   <dwellTime>
   <xsl:attribute name="unit"><xsl:value-of select="./id:bin0Duration/@unit"/></xsl:attribute>
   <xsl:value-of select="./id:bin0Duration"/>
   </dwellTime>
   
   <!-- add deadTime (value = ???) -->
   <deadTime unit="sec">0.0</deadTime>
   
   <!-- add numberOfPositions (value = binmode+1??) -->
   <numberOfPositions><xsl:value-of select="./id:binMode"/></numberOfPositions>
    
   <xsl:apply-templates select="id:centerFrequency"/>
   <xsl:apply-templates select="id:lO2Frequency"/>
   
   <xsl:apply-templates select="id:SpectralSubbandSet"/>
   
   <!-- delete bBC NOTHING TO DO -->    
   <!-- delete bin1duration -->
   <!-- delete numSwitchCycles -->
   <!-- delete aPCDataSets -->
   <!-- delete quantizationCorrection -->
   <!-- delete fFT -->
   <!-- delete channelAverageDuration -->
   <!-- delete attribute windowFunction -->
   <!-- delete attribute sideBand -->
   <!-- delete ChannelAverageBands -->
</BLBaseBandConfig>
</xsl:template>

<!-- Top level, rename to BL... -->
<xsl:template match="id:CorrelatorConfig">
<BLCorrelatorConfiguration>
   <!-- Add an attribute(?) aPCDataSets, taken from 1st? BBC. Need to change from numbers to enumeration -->
   <xsl:choose>
      <xsl:when test="./id:BaseBandConfig/id:aPCDataSets=0">
         <xsl:attribute name="aPCDataSets">AP_CORRECTED</xsl:attribute>
      </xsl:when>
      <xsl:when test="./id:BaseBandConfig/id:aPCDataSets=1">
         <xsl:attribute name="aPCDataSets">AP_UNCORRECTED</xsl:attribute>
      </xsl:when>
      <xsl:otherwise>
         <xsl:attribute name="aPCDataSets">AP_CORRECTED+AP_UNCORRECTED</xsl:attribute>
      </xsl:otherwise>
   </xsl:choose> 
   
    <!-- Add an attribute(?) receiverType - should come from receiver, but thats a bit much -->  
   <xsl:attribute name="receiverType">TSB</xsl:attribute>

   <!-- Add an element dumpDuration, value from (bin0duration + bin1duration)*numSwitchCycles (in first BBC?) -->
   <dumpDuration>
   <xsl:attribute name="unit"><xsl:value-of select="./id:BaseBandConfig/id:bin0Duration/@unit"/></xsl:attribute>
   <xsl:value-of select="./id:BaseBandConfig/id:bin0Duration"/>
   </dumpDuration>

   <!-- Add an element ChannelAverageDuration - taken from value in 1st? BBC -->
   <channelAverageDuration>
      <xsl:attribute name="unit"><xsl:value-of select="./id:BaseBandConfig/id:channelAverageDuration/@unit"/></xsl:attribute>
      <xsl:value-of select="./id:BaseBandConfig/id:channelAverageDuration"/>
   </channelAverageDuration>

   <xsl:apply-templates select="id:integrationDuration"/>

   <xsl:apply-templates select="id:subScanDuration"/>
   
   <xsl:apply-templates select="id:BaseBandConfig"/>

<!--   <xsl:apply-templates/> -->
   
</BLCorrelatorConfiguration>
</xsl:template>



</xsl:stylesheet>
