/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import uk.ac.starlink.table.RowStore;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.formats.AsciiTableBuilder;
import uk.ac.starlink.table.formats.CsvTableBuilder;
import uk.ac.starlink.table.formats.IpacTableBuilder;
import uk.ac.starlink.table.formats.TstTableBuilder;
import uk.ac.starlink.table.formats.WDCTableBuilder;
import uk.ac.starlink.table.jdbc.JDBCHandler;
import uk.ac.starlink.util.Compression;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.Loader;
import uk.ac.starlink.util.URLDataSource;

public class StarTableFactory {
    private List defaultBuilders_;
    private List knownBuilders_;
    private JDBCHandler jdbcHandler_;
    private boolean requireRandom_;
    private StoragePolicy storagePolicy_;
    public static final String KNOWN_BUILDERS_PROPERTY = "startable.readers";
    public static final String AUTO_HANDLER = "(auto)";
    private static Logger logger = Logger.getLogger("uk.ac.starlink.table");
    private static String[] defaultBuilderClasses = new String[]{"uk.ac.starlink.votable.FitsPlusTableBuilder", "uk.ac.starlink.votable.ColFitsPlusTableBuilder", "uk.ac.starlink.fits.ColFitsTableBuilder", "uk.ac.starlink.fits.FitsTableBuilder", "uk.ac.starlink.votable.VOTableBuilder"};
    private static String[] knownBuilderClasses = new String[]{AsciiTableBuilder.class.getName(), CsvTableBuilder.class.getName(), TstTableBuilder.class.getName(), IpacTableBuilder.class.getName(), WDCTableBuilder.class.getName()};
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$io$InputStream;

    public StarTableFactory() {
        this(false);
    }

    public StarTableFactory(boolean requireRandom) {
        TableBuilder builder;
        Class<?> clazz;
        String className;
        int i;
        this.requireRandom_ = requireRandom;
        this.defaultBuilders_ = new ArrayList();
        for (i = 0; i < defaultBuilderClasses.length; ++i) {
            className = defaultBuilderClasses[i];
            try {
                this.getClass();
                clazz = Class.forName(className);
                builder = (TableBuilder)clazz.newInstance();
                this.defaultBuilders_.add(builder);
                logger.config(className + " registered");
                continue;
            }
            catch (ClassNotFoundException e) {
                logger.config(className + " not found - can't register");
                continue;
            }
            catch (Exception e) {
                logger.config("Failed to register " + className + " - " + e);
            }
        }
        this.knownBuilders_ = new ArrayList(this.defaultBuilders_);
        for (i = 0; i < knownBuilderClasses.length; ++i) {
            className = knownBuilderClasses[i];
            try {
                this.getClass();
                clazz = Class.forName(className);
                builder = (TableBuilder)clazz.newInstance();
                this.knownBuilders_.add(builder);
                logger.config(className + " registered as known");
                continue;
            }
            catch (ClassNotFoundException e) {
                logger.config(className + " not found - can't register");
                continue;
            }
            catch (Exception e) {
                logger.config("Failed to register " + className + " - " + e);
            }
        }
        this.knownBuilders_.addAll(Loader.getClassInstances((String)KNOWN_BUILDERS_PROPERTY, (Class)TableBuilder.class));
    }

    public List getDefaultBuilders() {
        return this.defaultBuilders_;
    }

    public void setDefaultBuilders(TableBuilder[] builders) {
        this.defaultBuilders_ = new ArrayList<TableBuilder>(Arrays.asList(builders));
    }

    public List getKnownBuilders() {
        return this.knownBuilders_;
    }

    public void setKnownBuilders(TableBuilder[] builders) {
        this.knownBuilders_ = new ArrayList<TableBuilder>(Arrays.asList(builders));
    }

    public List getKnownFormats() {
        ArrayList<String> formats = new ArrayList<String>();
        Iterator it = this.getKnownBuilders().iterator();
        while (it.hasNext()) {
            Object b = it.next();
            if (!(b instanceof TableBuilder)) continue;
            formats.add(((TableBuilder)b).getFormatName());
        }
        return formats;
    }

    public void setRequireRandom(boolean requireRandom) {
        this.requireRandom_ = requireRandom;
    }

    public boolean requireRandom() {
        return this.requireRandom_;
    }

    public void setStoragePolicy(StoragePolicy policy) {
        this.storagePolicy_ = policy;
    }

    public StoragePolicy getStoragePolicy() {
        if (this.storagePolicy_ == null) {
            this.storagePolicy_ = StoragePolicy.getDefaultPolicy();
        }
        return this.storagePolicy_;
    }

    public StarTable randomTable(StarTable table) throws IOException {
        return this.getStoragePolicy().randomTable(table);
    }

    public StarTable makeStarTable(DataSource datsrc) throws TableFormatException, IOException {
        Iterator it = this.defaultBuilders_.iterator();
        while (it.hasNext()) {
            TableBuilder builder = (TableBuilder)it.next();
            try {
                StarTable startab = builder.makeStarTable(datsrc, this.requireRandom(), this.getStoragePolicy());
                startab = this.prepareTable(startab);
                startab.setURL(datsrc.getURL());
                if (startab.getName() == null) {
                    startab.setName(datsrc.getName());
                }
                return startab;
            }
            catch (TableFormatException e) {
                logger.info("Table not " + builder.getFormatName() + " - " + e.getMessage());
            }
        }
        StringBuffer msg = new StringBuffer();
        msg.append("Can't make StarTable from \"").append(datsrc.getName()).append("\"");
        Iterator it2 = this.defaultBuilders_.iterator();
        if (it2.hasNext()) {
            msg.append(" (tried");
            while (it2.hasNext()) {
                msg.append(" ").append(((TableBuilder)it2.next()).getFormatName());
                if (!it2.hasNext()) continue;
                msg.append(',');
            }
            msg.append(')');
        } else {
            msg.append(" - no table handlers available");
        }
        throw new TableFormatException(msg.toString());
    }

    public StarTable makeStarTable(String location) throws TableFormatException, IOException {
        if (location.startsWith("jdbc:")) {
            StarTable table = this.prepareTable(this.getJDBCHandler().makeStarTable(location, false));
            return this.requireRandom() ? this.randomTable(table) : table;
        }
        return this.makeStarTable(DataSource.makeDataSource((String)location));
    }

    public StarTable makeStarTable(URL url) throws IOException {
        return this.makeStarTable((DataSource)new URLDataSource(url));
    }

    public StarTable makeStarTable(DataSource datsrc, String handler) throws TableFormatException, IOException {
        StarTable startab;
        if (handler == null || handler.trim().length() == 0 || handler.equals(AUTO_HANDLER)) {
            return this.makeStarTable(datsrc);
        }
        TableBuilder builder = this.getTableBuilder(handler);
        try {
            startab = builder.makeStarTable(datsrc, this.requireRandom(), this.getStoragePolicy());
            startab = this.prepareTable(startab);
        }
        catch (TableFormatException e) {
            String msg = "Can't open " + datsrc.getName() + " as " + builder.getFormatName();
            String emsg = e.getMessage();
            msg = emsg != null && emsg.trim().length() > 0 ? msg + " (" + emsg + ")" : msg + " (" + e.toString() + ")";
            throw new TableFormatException(msg, e);
        }
        startab.setURL(datsrc.getURL());
        if (startab.getName() == null) {
            startab.setName(datsrc.getName());
        }
        return startab;
    }

    public StarTable makeStarTable(String location, String handler) throws TableFormatException, IOException {
        if (location.startsWith("jdbc:")) {
            StarTable table = this.prepareTable(this.getJDBCHandler().makeStarTable(location, false));
            return this.requireRandom() ? this.randomTable(table) : table;
        }
        if (location.equals("-")) {
            return this.makeStarTable(System.in, this.getTableBuilder(handler));
        }
        return this.makeStarTable(DataSource.makeDataSource((String)location), handler);
    }

    public StarTable makeStarTable(URL url, String handler) throws TableFormatException, IOException {
        return this.makeStarTable((DataSource)new URLDataSource(url), handler);
    }

    public StarTable makeStarTable(InputStream in, TableBuilder builder) throws TableFormatException, IOException {
        in = Compression.decompressStatic((InputStream)in);
        in = new BufferedInputStream(in);
        RowStore store = this.getStoragePolicy().makeRowStore();
        builder.streamStarTable(in, store, null);
        return this.prepareTable(store.getStarTable());
    }

    public StarTable makeStarTable(Transferable trans) throws IOException {
        DataFlavor[] flavors = trans.getTransferDataFlavors();
        StringBuffer msg = new StringBuffer();
        for (int i = 0; i < flavors.length; ++i) {
            DataFlavor flavor = flavors[i];
            String mimeType = flavor.getMimeType();
            Class<?> clazz = flavor.getRepresentationClass();
            if (clazz.equals(class$java$net$URL == null ? StarTableFactory.class$("java.net.URL") : class$java$net$URL)) {
                try {
                    Object data = trans.getTransferData(flavor);
                    if (data instanceof URL) {
                        URL url = (URL)data;
                        return this.makeStarTable(url);
                    }
                }
                catch (UnsupportedFlavorException e) {
                    throw new RuntimeException("DataFlavor " + flavor + " support withdrawn?");
                }
                catch (TableFormatException e) {
                    msg.append(e.getMessage());
                }
            }
            if (!(class$java$io$InputStream == null ? StarTableFactory.class$("java.io.InputStream") : class$java$io$InputStream).isAssignableFrom(clazz) || flavor.isFlavorSerializedObjectType()) continue;
            Iterator it = this.defaultBuilders_.iterator();
            while (it.hasNext()) {
                InputStream in;
                TableBuilder builder = (TableBuilder)it.next();
                if (!builder.canImport(flavor)) continue;
                try {
                    in = (InputStream)trans.getTransferData(flavor);
                }
                catch (UnsupportedFlavorException e) {
                    throw new RuntimeException("DataFlavor " + flavor + " support withdrawn?");
                }
                return this.makeStarTable(in, builder);
            }
        }
        throw new TableFormatException(msg.toString());
    }

    public boolean canImport(DataFlavor[] flavors) {
        for (int i = 0; i < flavors.length; ++i) {
            DataFlavor flavor = flavors[i];
            String mimeType = flavor.getMimeType();
            Class<?> clazz = flavor.getRepresentationClass();
            if (clazz.equals(class$java$net$URL == null ? StarTableFactory.class$("java.net.URL") : class$java$net$URL)) {
                return true;
            }
            Iterator it = this.defaultBuilders_.iterator();
            while (it.hasNext()) {
                TableBuilder builder = (TableBuilder)it.next();
                if (!builder.canImport(flavor)) continue;
                return true;
            }
        }
        return false;
    }

    public JDBCHandler getJDBCHandler() {
        if (this.jdbcHandler_ == null) {
            this.jdbcHandler_ = new JDBCHandler();
        }
        return this.jdbcHandler_;
    }

    public void setJDBCHandler(JDBCHandler handler) {
        this.jdbcHandler_ = handler;
    }

    public TableBuilder getTableBuilder(String name) throws TableFormatException {
        if (name == null) {
            throw new TableFormatException("No table handler with null name");
        }
        ArrayList builders = new ArrayList(this.knownBuilders_);
        Iterator it = builders.iterator();
        while (it.hasNext()) {
            TableBuilder builder = (TableBuilder)it.next();
            if (!builder.getFormatName().equalsIgnoreCase(name)) continue;
            return builder;
        }
        try {
            this.getClass();
            Class<?> clazz = Class.forName(name);
            if (TableBuilder.class.isAssignableFrom(clazz)) {
                return (TableBuilder)clazz.newInstance();
            }
            throw new TableFormatException("Class " + clazz + " does not implement TableBuilder");
        }
        catch (InstantiationException e) {
            throw new TableFormatException(e.toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new TableFormatException(e.toString(), e);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TableFormatException("No table handler available for " + name);
        }
    }

    private StarTable prepareTable(StarTable startab) throws IOException {
        return this.requireRandom() ? this.randomTable(startab) : startab;
    }
}

