/*
 * Decompiled with CFR 0.152.
 */
package diva.gui;

import diva.gui.Application;
import diva.gui.Document;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.URL;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;

public abstract class AbstractDocument
implements Document {
    private boolean _dirty = false;
    private boolean _editable = true;
    private boolean _writable = true;
    private PropertyChangeSupport _propertyChange;
    private Application _application = null;
    private File _file = null;
    private URL _url = null;
    private UndoManager _undoManager = null;
    private UndoableEditSupport _editSupport = null;

    public AbstractDocument(Application a) {
        this._application = a;
        this._undoManager = new UndoManager();
        this._editSupport = new UndoableEditSupport();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this._propertyChange == null) {
            this._propertyChange = new PropertyChangeSupport(this);
        }
        this._propertyChange.addPropertyChangeListener(listener);
    }

    public UndoableEditSupport getEditSupport() {
        return this._editSupport;
    }

    public UndoManager getUndoManager() {
        return this._undoManager;
    }

    public void close() throws Exception {
    }

    public Application getApplication() {
        return this._application;
    }

    public File getFile() {
        return this._file;
    }

    public String getShortTitle() {
        if (this.getFile() != null) {
            return this.getFile().getName();
        }
        if (this.getURL() != null) {
            return this.getURL().getFile();
        }
        return "Untitled";
    }

    public String getTitle() {
        if (this.getFile() != null) {
            return this.getFile().getAbsolutePath();
        }
        if (this.getURL() != null) {
            return this.getURL().toString();
        }
        return "Untitled";
    }

    public URL getURL() {
        return this._url;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public boolean isEditable() {
        return this._editable;
    }

    public boolean isWritable() {
        return this._writable;
    }

    public abstract void open() throws Exception;

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._propertyChange.removePropertyChangeListener(listener);
    }

    public abstract void save() throws Exception;

    public abstract void saveAs(File var1) throws Exception;

    public abstract void saveAs(URL var1) throws Exception;

    public void setFile(File file) {
        File old = this._file;
        this._file = file;
        if (this._propertyChange != null) {
            this._propertyChange.firePropertyChange("file", old, file);
        }
    }

    public void setURL(URL url) {
        URL old = this._url;
        this._url = url;
        if (this._propertyChange != null) {
            this._propertyChange.firePropertyChange("url", old, url);
        }
    }

    public void setEditable(boolean flag) {
        boolean old = this._editable;
        this._editable = flag;
        if (this._propertyChange != null) {
            this._propertyChange.firePropertyChange("editable", old, flag);
        }
    }

    public void setDirty(boolean flag) {
        boolean old = this._dirty;
        this._dirty = flag;
        if (this._propertyChange != null) {
            this._propertyChange.firePropertyChange("dirty", old, flag);
        }
    }

    public void setWritable(boolean flag) {
        boolean old = this._writable;
        this._writable = flag;
        if (this._propertyChange != null) {
            this._propertyChange.firePropertyChange("writable", old, flag);
        }
    }
}

