/*
 * Decompiled with CFR 0.152.
 */
package diva.util.java2d;

import diva.util.java2d.AbstractPaintedGraphic;
import diva.util.java2d.ShapeUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public class PaintedShape
extends AbstractPaintedGraphic {
    public Paint fillPaint;

    public PaintedShape(Shape shape) {
        this(shape, null, 1.0f, Color.black);
    }

    public PaintedShape(Shape shape, Paint fillPaint) {
        this(shape, fillPaint, 1.0f, null);
    }

    public PaintedShape(Shape shape, float lineWidth) {
        this(shape, null, lineWidth, Color.black);
    }

    public PaintedShape(Shape shape, Paint fillPaint, float lineWidth) {
        this(shape, fillPaint, lineWidth, Color.black);
    }

    public PaintedShape(Shape shape, float lineWidth, Paint strokePaint) {
        this(shape, null, lineWidth, strokePaint);
    }

    public PaintedShape(Shape shape, Paint fillPaint, float lineWidth, Paint strokePaint) {
        this.shape = shape;
        this.setFillPaint(fillPaint);
        this.setStrokePaint(strokePaint);
        this.setLineWidth(lineWidth);
    }

    public float getLineWidth() {
        if (this.stroke == null) {
            return 0.0f;
        }
        return ((BasicStroke)this.stroke).getLineWidth();
    }

    public boolean hit(Rectangle2D r) {
        if (this.fillPaint != null) {
            return this.shape.intersects(r);
        }
        return ShapeUtilities.intersectsOutline(r, this.shape);
    }

    public boolean intersects(Rectangle2D r) {
        return this.shape.intersects(r);
    }

    public void paint(Graphics2D g) {
        if (this.fillPaint != null) {
            g.setPaint(this.fillPaint);
            g.fill(this.shape);
        }
        if (this.stroke != null && this.strokePaint != null) {
            g.setStroke(this.stroke);
            g.setPaint(this.strokePaint);
            g.draw(this.shape);
        }
    }

    public void setLineWidth(float lineWidth) {
        if ((double)lineWidth <= 0.0) {
            this.stroke = null;
        } else if (this.stroke == null || lineWidth != ((BasicStroke)this.stroke).getLineWidth()) {
            this.stroke = AbstractPaintedGraphic.getStroke(lineWidth);
        }
    }

    public void setStrokePaint(Paint strokePaint) {
        this.strokePaint = strokePaint;
    }

    public void setFillPaint(Paint fillPaint) {
        this.fillPaint = fillPaint;
    }
}

