/*
 * Decompiled with CFR 0.152.
 */
package jsky.util;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.SAXParserFactory;
import jsky.util.Resources;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SaxParserUtil
extends DefaultHandler {
    private String _cdata = null;
    private Class[] _parameterTypes = new Class[]{Attributes.class};
    private URL _url;

    public void parse(URL url) {
        this._url = url;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            XMLReader parser = factory.newSAXParser().getXMLReader();
            parser.setEntityResolver(this);
            parser.setContentHandler(this);
            parser.setErrorHandler(this);
            parser.parse(url.toString());
        }
        catch (SAXException e) {
            e.printStackTrace();
            Exception ee = e.getException();
            while (ee != null) {
                ee.printStackTrace();
                if (ee instanceof SAXException) {
                    ee = ((SAXException)ee).getException();
                    continue;
                }
                ee = null;
            }
            throw new RuntimeException("SAX Error parsing XML document: " + e.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void parse(URL url, InputSource inputSource) {
        this._url = url;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            XMLReader parser = factory.newSAXParser().getXMLReader();
            parser.setEntityResolver(this);
            parser.setContentHandler(this);
            parser.setErrorHandler(this);
            parser.parse(inputSource);
        }
        catch (SAXException e) {
            e.printStackTrace();
            Exception ee = e.getException();
            while (ee != null) {
                ee.printStackTrace();
                if (ee instanceof SAXException) {
                    ee = ((SAXException)ee).getException();
                    continue;
                }
                ee = null;
            }
            throw new RuntimeException("SAX Error parsing XML document: " + e.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void parse(String urlStr) throws MalformedURLException {
        this.parse(new URL(urlStr));
    }

    public void parse(Reader reader) {
        this.parse(null, new InputSource(reader));
    }

    public void parse(URL url, InputStream in) {
        this.parse(url, new InputSource(in));
    }

    public URL getURL() {
        return this._url;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        try {
            String fileName = systemId;
            if (fileName.startsWith("jar:") || fileName.startsWith("file:") || fileName.startsWith("http:")) {
                fileName = new File(new URL(fileName).getFile()).getName();
            }
            URL url = Resources.getResource(fileName);
            return new InputSource(url.openStream());
        }
        catch (Exception e) {
            throw new RuntimeException("Error resolving entity: " + systemId, e);
        }
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXParseException {
        System.out.println("XML input line " + e.getLineNumber() + ": Fatal error: " + e.getMessage());
        throw e;
    }

    @Override
    public void error(SAXParseException e) throws SAXParseException {
        System.out.println("XML input line " + e.getLineNumber() + ": Error: " + e.getMessage());
        throw e;
    }

    @Override
    public void warning(SAXParseException e) throws SAXParseException {
        System.out.println("XML input line " + e.getLineNumber() + ": Warning: " + e.getMessage());
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
        Object[] args = new Object[]{attrs};
        String methodName = "_" + qName + "Start";
        try {
            this.getClass().getMethod(methodName, this._parameterTypes).invoke((Object)this, args);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
        this._cdata = null;
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        String methodName = "_" + qName + "End";
        try {
            this.getClass().getMethod(methodName, new Class[0]).invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
        this._cdata = null;
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        String s = new String(buf, offset, len);
        this._cdata = this._cdata == null ? s : this._cdata + s;
    }

    protected String getCData() {
        return this._cdata;
    }

    protected void setCData(String s) {
        this._cdata = s;
    }
}

