/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.mvc.widgets;

import alma.obsprep.util.job.AbstractJob;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;

public class IndeterminateProgressMonitor
implements PropertyChangeListener {
    public static final String CANCELLED_PROPERTY_NAME = "IPM_CANCELLED";
    private final String cancelOption = UIManager.getString("OptionPane.cancelButtonText");
    private final String backgroundOption = "Run in Background";
    private IndeterminateProgressMonitor root;
    private final Dialog.ModalityType modality;
    private AbstractJob job;
    private JDialog dialog;
    private JOptionPane pane;
    private JProgressBar myBar;
    private JLabel noteLabel;
    private final Component parentComponent;
    private String note;
    private final Object message;
    private int millisToPopup = 1000;
    private final Timer timer = new Timer();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public IndeterminateProgressMonitor(Component component, Object object, String string) {
        this(component, object, string, null, Dialog.ModalityType.MODELESS);
    }

    public IndeterminateProgressMonitor(Component component, Object object, String string, Dialog.ModalityType modalityType) {
        this(component, object, string, null, modalityType);
    }

    private IndeterminateProgressMonitor(Component component, Object object, String string, IndeterminateProgressMonitor indeterminateProgressMonitor, Dialog.ModalityType modalityType) {
        this.parentComponent = component;
        this.modality = modalityType;
        this.message = object;
        this.note = string;
        if (indeterminateProgressMonitor != null) {
            this.root = indeterminateProgressMonitor.root != null ? indeterminateProgressMonitor.root : indeterminateProgressMonitor;
            this.dialog = this.root.dialog;
        }
    }

    public IndeterminateProgressMonitor(Component component, AbstractJob abstractJob) {
        this(component, abstractJob.info.description, "");
        this.job = abstractJob;
        abstractJob.addPropertyChangeListener(this);
    }

    private void closeLater() {
        SwingUtilities.invokeLater(() -> this.close());
    }

    public void close() {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.dialog = null;
            this.pane = null;
            this.myBar = null;
        }
    }

    public boolean isCancelled() {
        if (this.pane == null) {
            return false;
        }
        Object object = this.pane.getValue();
        return this.cancelOption.equals(object);
    }

    public AbstractJob getJob() {
        return this.job;
    }

    public void setMillisToPopup(int n) {
        this.millisToPopup = n;
    }

    public int getMillisToPopup() {
        return this.millisToPopup;
    }

    public void setNote(String string) {
        this.note = string;
        if (this.noteLabel != null) {
            this.noteLabel.setText(string);
        }
    }

    public String getNote() {
        return this.note;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("state")) {
            Object object = propertyChangeEvent.getNewValue();
            if (SwingWorker.StateValue.STARTED.equals(object) && this.myBar == null) {
                this.timer.schedule((TimerTask)new PopupTimerTask(), this.millisToPopup);
            } else if (SwingWorker.StateValue.DONE.equals(object)) {
                this.timer.cancel();
                this.closeLater();
            }
        }
    }

    private void launchPopup() {
        SwingUtilities.invokeLater(() -> {
            this.myBar = new JProgressBar();
            this.myBar.setName("ProgressDialog.ProgressBar");
            this.myBar.setIndeterminate(true);
            this.noteLabel = new JLabel(this.note);
            Object[] objectArray = new Object[]{this.message, this.noteLabel, this.myBar};
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("Run in Background");
            if (this.pcs.hasListeners(null)) {
                arrayList.add(this.cancelOption);
            }
            this.pane = new ProgressOptionPane(objectArray, arrayList.toArray());
            this.dialog = this.pane.createDialog(this.parentComponent, UIManager.getString("ProgressMonitor.progressText"));
            this.dialog.setName("ProgressDialog");
            this.dialog.setVisible(true);
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    private class PopupTimerTask
    extends TimerTask {
        private PopupTimerTask() {
        }

        @Override
        public void run() {
            IndeterminateProgressMonitor.this.launchPopup();
        }
    }

    private class ProgressOptionPane
    extends JOptionPane {
        ProgressOptionPane(Object object, Object[] objectArray) {
            super(object, -1, -1, null, objectArray, null);
        }

        @Override
        public int getMaxCharactersPerLineCount() {
            return 60;
        }

        @Override
        public JDialog createDialog(Component component, String string) {
            JDialog jDialog = super.createDialog(component, string);
            jDialog.setModalityType(IndeterminateProgressMonitor.this.modality);
            jDialog.addWindowListener(new WindowAdapter(){
                boolean gotFocus = false;

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    ProgressOptionPane.this.setValue(ProgressOptionPane.this.initialValue);
                }

                @Override
                public void windowActivated(WindowEvent windowEvent) {
                    if (!this.gotFocus) {
                        ProgressOptionPane.this.selectInitialValue();
                        this.gotFocus = true;
                    }
                }
            });
            this.addPropertyChangeListener(propertyChangeEvent -> {
                if (propertyChangeEvent.getSource() == this && (propertyChangeEvent.getPropertyName().equals("value") || propertyChangeEvent.getPropertyName().equals("inputValue"))) {
                    if (IndeterminateProgressMonitor.this.cancelOption.equals(propertyChangeEvent.getNewValue())) {
                        IndeterminateProgressMonitor.this.timer.cancel();
                        jDialog.setVisible(false);
                        jDialog.dispose();
                        IndeterminateProgressMonitor.this.pcs.firePropertyChange(IndeterminateProgressMonitor.CANCELLED_PROPERTY_NAME, false, true);
                    } else if ("Run in Background".equals(propertyChangeEvent.getNewValue())) {
                        jDialog.setVisible(false);
                        jDialog.dispose();
                    }
                }
            });
            return jDialog;
        }
    }
}

