/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.CompositionChild;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.BOUtilities;
import alma.obsprep.bo.OusCollection;
import alma.obsprep.bo.SubSBCollection;
import alma.obsprep.bo.annotations.AddableToSubSBCollection;
import alma.obsprep.bo.annotations.AttachableToTarget;
import alma.obsprep.bo.annotations.GUIScienceGoalAcceptor;
import alma.obsprep.bo.annotations.SpecialCaseForConfirmOnDelete;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.UnitDependencies;
import alma.obsprep.bo.obsproject.data.UnitDependenciesData;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.ot.actions.ActionLog;
import alma.obsprep.ot.actions.DeleteInteractor;
import alma.obsprep.ot.actions.Performer;
import java.util.Arrays;
import java.util.List;
import javax.swing.tree.TreeNode;
import lombok.NonNull;

public class DeletePerformer
extends Performer {
    private AbstractScienceGoal scienceGoal = null;

    public DeletePerformer(DeleteInteractor deleteInteractor) {
        super(deleteInteractor);
    }

    @Override
    public void perform() {
        DeleteInteractor deleteInteractor = (DeleteInteractor)this.getGui();
        BusinessObject businessObject = deleteInteractor.getSelectedBO();
        if (businessObject instanceof SpecialCaseForConfirmOnDelete) {
            if (businessObject instanceof AbstractScienceGoal) {
                BusinessObject businessObject2 = deleteInteractor.getParentBO();
                if (businessObject2 instanceof GUIScienceGoalAcceptor) {
                    AbstractScienceGoal abstractScienceGoal = (AbstractScienceGoal)businessObject;
                    GUIScienceGoalAcceptor gUIScienceGoalAcceptor = (GUIScienceGoalAcceptor)businessObject2;
                    boolean bl = false;
                    ObsUnitSet obsUnitSet = abstractScienceGoal.getObsUnitSet();
                    if (obsUnitSet == null) {
                        if (deleteInteractor.confirmDelete()) {
                            gUIScienceGoalAcceptor.removeScienceGoal(abstractScienceGoal);
                            bl = true;
                        }
                    } else if (deleteInteractor.confirmDeleteScienceGoalWithGeneratedOus()) {
                        obsUnitSet.removeFromParent();
                        gUIScienceGoalAcceptor.removeScienceGoal(abstractScienceGoal);
                        bl = true;
                    }
                    if (bl) {
                        ActionLog.performed("Delete", businessObject, "from", businessObject2);
                        TreeNode treeNode = deleteInteractor.getParentNode();
                        deleteInteractor.updateDisplay(treeNode);
                    }
                } else if (deleteInteractor.confirmDelete()) {
                    this.performOnceConfirmed(deleteInteractor, businessObject);
                }
            }
        } else {
            boolean bl;
            if (businessObject instanceof OusCollection) {
                deleteInteractor.deleteGuiSpecialNode();
                return;
            }
            this.scienceGoal = BOUtilities.findScienceGoal(businessObject);
            if (this.scienceGoal != null) {
                bl = deleteInteractor.confirmDeleteGeneratedOusOrPartOfIt(this.scienceGoal.getObsUnitSet() == businessObject, businessObject, (BusinessObject)this.scienceGoal);
                if (bl && businessObject instanceof ObsUnitSet) {
                    this.deleteUnitDependenciesToSBsUnderOUSToBeDeleted((ObsUnitSet)businessObject);
                }
            } else {
                bl = businessObject == BOUtilities.findRepresentativeTarget(businessObject) ? deleteInteractor.confirmDeleteRepresentativeTarget() : deleteInteractor.confirmDelete();
            }
            if (bl && businessObject instanceof SchedBlock && (bl = deleteInteractor.confirmDeleteOfSBWithUnitDependency(businessObject))) {
                this.deleteAllUnitDependenciesOnTargetSB((SchedBlock)businessObject, deleteInteractor);
            }
            if (bl) {
                this.performOnceConfirmed(deleteInteractor, businessObject);
            }
            this.scienceGoal = null;
        }
    }

    private void deleteUnitDependenciesToSBsUnderOUSToBeDeleted(@NonNull ObsUnitSet obsUnitSet) {
        List<SchedBlock> list;
        if (obsUnitSet == null) {
            throw new NullPointerException("ousToDelete is marked non-null but is null");
        }
        try {
            list = obsUnitSet.findSchedBlocks();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(DeletePerformer.class).warning("Unable to determine SBs under OUS " + unknownEntityException.getMessage());
            return;
        }
        for (SchedBlock schedBlock : ObsProject.getAllSBsInProject()) {
            for (SchedBlock schedBlock2 : list) {
                if (schedBlock2.equals(schedBlock)) continue;
                UnitDependencies unitDependencies = UnitDependenciesData.createUnitDependencies();
                Arrays.asList(schedBlock.getUnitDependencies().getDependencyList()).stream().filter(string -> !string.equals(schedBlock2.getEntityID())).forEach(string -> unitDependencies.addDependencyList((String)string));
                schedBlock.setUnitDependencies(unitDependencies);
            }
        }
    }

    private void deleteAllUnitDependenciesOnTargetSB(SchedBlock schedBlock, DeleteInteractor deleteInteractor) {
        List<SchedBlock> list = deleteInteractor.getAllSBsWithDependencyOnTargetSB(schedBlock);
        for (SchedBlock schedBlock2 : list) {
            UnitDependencies unitDependencies = UnitDependenciesData.createUnitDependencies();
            for (String string : schedBlock2.getUnitDependencies().getDependencyList()) {
                if (string.equals(schedBlock.getEntityID())) continue;
                unitDependencies.addDependencyList(string);
            }
            schedBlock2.setUnitDependencies(unitDependencies);
        }
    }

    private void performOnceConfirmed(DeleteInteractor deleteInteractor, BusinessObject businessObject) {
        Object object;
        BusinessObject businessObject2 = deleteInteractor.getParentBO();
        if (businessObject instanceof AttachableToTarget && ((AttachableToTarget)businessObject).getUsedCount() > 0) {
            deleteInteractor.error("Cannot delete " + businessObject.getNameOrDefault() + ", which is in use.");
            return;
        }
        if (businessObject instanceof CompositionChild) {
            ((CompositionChild)businessObject).removeFromParent();
            ActionLog.performed("Delete", businessObject, "from", businessObject2);
        }
        if (businessObject instanceof AddableToSubSBCollection && (object = ((SubSBCollection)businessObject2).getSchedBlock()) != null && businessObject instanceof Target && businessObject == object.getSchedulingConstraints().getRepresentativeTarget()) {
            object.getSchedulingConstraints().setRepresentativeTarget(null);
        }
        if (businessObject instanceof ObsUnitSet && this.scienceGoal != null && this.scienceGoal.getObsUnitSet() == businessObject) {
            this.scienceGoal.setObsUnitSet(null);
        }
        object = deleteInteractor.getParentNode();
        deleteInteractor.updateDisplay((TreeNode)object);
    }
}

