/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.boEditors;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.MultipageView;
import alma.obsprep.guiutil.mvc.MultipageViewException;
import alma.obsprep.guiutil.mvc.View;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

public abstract class MultiPageEditor
extends Editor
implements MultipageView {
    private static final long serialVersionUID = -2949893474329753269L;
    protected JPanel cardPanel;
    protected List<PagePanel> pages = new ArrayList<PagePanel>();

    protected MultiPageEditor() {
    }

    protected MultiPageEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    public void build() {
        this.setLayout(new BoxLayout(this, 3));
        this.cardPanel = new JPanel();
        this.add((Component)this.cardPanel, "Center");
    }

    public PagePanel addPage(View view, PageDescriptor pageDescriptor, String[] stringArray) {
        return this.addPage(view, pageDescriptor, stringArray, true);
    }

    public PagePanel addPage(View view, PageDescriptor pageDescriptor, String[] stringArray, boolean bl) {
        PagePanel pagePanel = new PagePanel(pageDescriptor, view);
        pagePanel.setLayout(new BorderLayout());
        Box box = Box.createVerticalBox();
        if (stringArray != null && stringArray.length > 0) {
            box.setBorder(new EtchedBorder());
            JLabel jLabel = null;
            box.add(Box.createVerticalStrut(10));
            for (String string : stringArray) {
                jLabel = new JLabel("  " + string);
                box.add(jLabel);
            }
            box.add(Box.createVerticalStrut(10));
        }
        pagePanel.addDescriptionComponent(box, "North");
        pagePanel.add((Component)view, "Center");
        this.cardPanel.add((Component)pagePanel, pageDescriptor.getTitle());
        this.pages.add(pagePanel);
        return pagePanel;
    }

    public int getNumPages() {
        return this.pages.size();
    }

    public String getPageName(int n) throws ArrayIndexOutOfBoundsException {
        return this.pages.get(n).getPageDescriptor().getTitle();
    }

    public View getPageContent(int n) throws ArrayIndexOutOfBoundsException {
        return this.pages.get(n).getContentComponent();
    }

    @Override
    public boolean isMultipage() {
        return true;
    }

    @Override
    public void displayPageFor(BusinessObject businessObject) throws MultipageViewException {
        throw new MultipageViewException(String.format("Use a page number to control which page of a %s is displayed", this.getClass().getSimpleName()));
    }

    @Override
    public void displayPageNumber(int n) throws MultipageViewException {
        try {
            for (PagePanel pagePanel : this.pages) {
                pagePanel.setVisible(false);
            }
            this.pages.get(n).setVisible(true);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    public boolean hasPageNumbers() {
        return true;
    }

    @Override
    public void showAllPageInOneView(boolean bl) {
        if (bl) {
            this.cardPanel.setLayout(new BoxLayout(this.cardPanel, 3));
            for (Component component : this.cardPanel.getComponents()) {
                component.setVisible(true);
                if (!(component instanceof PagePanel)) continue;
                PagePanel pagePanel = (PagePanel)component;
                pagePanel.setDescriptionVisible(false);
                pagePanel.hideIfNotShownInMultiViewDisplay();
            }
        } else {
            for (Component component : this.cardPanel.getComponents()) {
                component.setVisible(false);
                if (!(component instanceof PagePanel)) continue;
                ((PagePanel)component).setDescriptionVisible(true);
            }
        }
    }

    protected class PageDescriptor {
        private final String title;

        public PageDescriptor(MultiPageEditor multiPageEditor, String string) {
            this.title = string;
        }

        protected String getTitle() {
            return this.title;
        }
    }

    protected class PagePanel
    extends JPanel {
        private static final long serialVersionUID = -7869144900151361073L;
        private final PageDescriptor pageDescriptor;
        private JComponent descriptionComponent = null;
        private final View contentComponent;
        private boolean visibleInMultiView = true;

        public void hideIfNotShownInMultiViewDisplay() {
            this.setVisible(this.visibleInMultiView);
        }

        protected PagePanel(PageDescriptor pageDescriptor, View view) {
            this.pageDescriptor = pageDescriptor;
            this.contentComponent = view;
        }

        protected void addDescriptionComponent(JComponent jComponent, Object object) {
            super.add((Component)jComponent, object);
            this.descriptionComponent = jComponent;
        }

        protected void setDescriptionVisible(boolean bl) {
            if (this.descriptionComponent != null) {
                this.descriptionComponent.setVisible(bl);
            }
        }

        public PageDescriptor getPageDescriptor() {
            return this.pageDescriptor;
        }

        public View getContentComponent() {
            return this.contentComponent;
        }

        public void setVisibleInMultiView(boolean bl) {
            this.visibleInMultiView = bl;
        }
    }
}

