/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.obsprep.bo.annotations.SpatialDocument;
import alma.obsprep.bo.annotations.SpatialPartOfSpatialDocument;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.obsproject.ObsUnitControl;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.SkyCoordinates;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class SpatialVisualParameters
implements Serializable {
    public static final String DEFAULT_IMAGESERVER = "Digitized Sky (Version II) at ESO";
    private static final Collection<String> TWELVE_M_ARRAYS = List.of(ObsUnitControl.ARRAYREQUESTED_TWELVE_M, ObsUnitControl.ARRAYREQUESTED_TP_ARRAY);
    private SpatialDocument spatialDocument;
    private final SpatialPartOfSpatialDocument parentSpatialPart;
    private Frequency frequency = Frequency.createFrequency();
    private String singleFrequencySource = "";
    private Antenna antenna = Antenna.ANTENNA_12M;
    private boolean showsFov = true;
    private String imageServer = "Digitized Sky (Version II) at ESO";
    private double size = 10.0;
    private String filename = null;
    private boolean isPhaseOne = true;

    public SpatialVisualParameters(SpatialPartOfSpatialDocument spatialPartOfSpatialDocument) {
        this.parentSpatialPart = spatialPartOfSpatialDocument;
    }

    public void setContextDocument(SpatialDocument spatialDocument) {
        this.spatialDocument = spatialDocument;
        this.setSingleFrequency(spatialDocument.getSingleFrequency());
        this.setSingleFrequencySource(spatialDocument.getSingleFrequencySource());
        if (spatialDocument instanceof BusinessObject) {
            BusinessObject businessObject = (BusinessObject)spatialDocument;
            BusinessObject businessObject2 = businessObject.getParent();
            if (businessObject2 instanceof SchedBlock) {
                SchedBlock schedBlock = (SchedBlock)businessObject2;
                Antenna antenna = TWELVE_M_ARRAYS.contains(schedBlock.getObsUnitControl().getArrayRequested()) ? Antenna.ANTENNA_12M : Antenna.ANTENNA_7M;
                this.setAntenna(antenna);
                this.isPhaseOne = false;
            } else {
                this.isPhaseOne = true;
            }
        }
    }

    public SpatialDocument getContextDocument() {
        return this.spatialDocument;
    }

    public Angle getFovSize() {
        return this.antenna.getBeamSize(this.getFrequency());
    }

    public SpatialPartOfSpatialDocument getParent() {
        return this.parentSpatialPart;
    }

    public String getSourceName() {
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().getSourceName();
    }

    public SkyCoordinates getSourceCoordinates() {
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().getSourceCoordinates();
    }

    public void setSingleFrequency(Frequency frequency) {
        Frequency frequency2 = frequency == null ? Frequency.createFrequency() : frequency;
        this.getFrequency().setContentAndUnit((ValueUnitPair)frequency2);
    }

    public SpatialDocument getSpatialDocument() {
        return this.spatialDocument;
    }

    public SpatialPartOfSpatialDocument getParentSpatialPart() {
        return this.parentSpatialPart;
    }

    public void setFrequency(Frequency frequency) {
        this.frequency = frequency;
    }

    public Frequency getFrequency() {
        return this.frequency;
    }

    public String getSingleFrequencySource() {
        return this.singleFrequencySource;
    }

    public void setSingleFrequencySource(String string) {
        this.singleFrequencySource = string;
    }

    public Antenna getAntenna() {
        return this.antenna;
    }

    public void setAntenna(Antenna antenna) {
        this.antenna = antenna;
    }

    public boolean isShowsFov() {
        return this.showsFov;
    }

    public void setShowsFov(boolean bl) {
        this.showsFov = bl;
    }

    public String getImageServer() {
        return this.imageServer;
    }

    public void setImageServer(String string) {
        this.imageServer = string;
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double d) {
        this.size = d;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public boolean isPhaseOne() {
        return this.isPhaseOne;
    }
}

