/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual.mapper;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.guiutil.jsky.navigator.AlmaNavigatorImageDisplayPanel;
import alma.obsprep.ot.editors.spatialvisual.mapper.CenterMapperModel;
import alma.obsprep.ot.editors.spatialvisual.mapper.Mapper;
import alma.obsprep.ot.editors.spatialvisual.mapper.TargetCenterFigure;
import alma.valuetypes.SkyCoordinates;
import diva.canvas.interactor.DragInteractor;
import diva.canvas.interactor.Interactor;
import java.awt.event.MouseEvent;
import jsky.graphics.CanvasFigureEvent;
import jsky.graphics.CanvasFigureListener;
import jsky.graphics.CanvasFigureListenerAdapter;

public class CenterMapper
extends Mapper {
    public CenterMapper(AlmaNavigatorImageDisplayPanel almaNavigatorImageDisplayPanel, CenterMapperModel centerMapperModel) {
        super(almaNavigatorImageDisplayPanel, centerMapperModel);
    }

    @Override
    public CenterMapperModel getModel() {
        return (CenterMapperModel)super.getModel();
    }

    protected TargetCenterFigure draw(MouseEvent mouseEvent) {
        if (!this.isWcsSet(true)) {
            this.setDrawing(false);
            return null;
        }
        SkyCoordinates skyCoordinates = this.getModel().addTargetCenter();
        TargetCenterFigure targetCenterFigure = this.update(skyCoordinates);
        double d = (double)mouseEvent.getX() - targetCenterFigure.getBounds().getCenterX();
        double d2 = (double)mouseEvent.getY() - targetCenterFigure.getBounds().getCenterY();
        targetCenterFigure.translate(d, d2);
        return targetCenterFigure;
    }

    protected TargetCenterFigure update(SkyCoordinates skyCoordinates) {
        TargetCenterFigure targetCenterFigure;
        if (!this.isWcsSet(false)) {
            return null;
        }
        if (this.boFigureListManager.figureTableContainsBO((BusinessObject)skyCoordinates)) {
            targetCenterFigure = (TargetCenterFigure)this.boFigureListManager.getFigure((BusinessObject)skyCoordinates);
        } else {
            targetCenterFigure = this.createTargetCenterFigure(skyCoordinates);
            this.boFigureListManager.add((BusinessObject)skyCoordinates, targetCenterFigure);
        }
        this.imagePanel.getImageDisplay().translateFigureTo(targetCenterFigure, skyCoordinates);
        return targetCenterFigure;
    }

    protected void translateTargetCenterFigure(SkyCoordinates skyCoordinates) {
        TargetCenterFigure targetCenterFigure = (TargetCenterFigure)this.boFigureListManager.getFigure((BusinessObject)skyCoordinates);
        if (targetCenterFigure != null) {
            this.imagePanel.getImageDisplay().translateFigureTo(targetCenterFigure, skyCoordinates);
        }
    }

    protected TargetCenterFigure createTargetCenterFigure(SkyCoordinates skyCoordinates) {
        TargetCenterFigure targetCenterFigure = this.makeTargetCenterFigure(0.0, 0.0);
        targetCenterFigure.setBusinessObject((BusinessObject)skyCoordinates);
        DragInteractor dragInteractor = this.imagePanel.getImageGraphics().getDragInteractor();
        targetCenterFigure.setInteractor((Interactor)dragInteractor);
        this.imagePanel.getAlmaCanvasDraw().addFigure(targetCenterFigure);
        targetCenterFigure.addCanvasFigureListener((CanvasFigureListener)new CanvasFigureListenerAdapter(){

            public void figureMoved(CanvasFigureEvent canvasFigureEvent) {
                CenterMapper.this.getModel().updateBO((TargetCenterFigure)canvasFigureEvent.getFigure());
            }
        });
        return targetCenterFigure;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.isDrawing()) {
            TargetCenterFigure targetCenterFigure = this.draw(mouseEvent);
            this.setDrawing(false);
            if (targetCenterFigure != null) {
                this.getModel().updateBO(targetCenterFigure);
            }
        }
    }

    protected TargetCenterFigure makeTargetCenterFigure(double d, double d2) {
        return this.makeTargetCenterFigure(d, d2, 10);
    }

    protected TargetCenterFigure makeTargetCenterFigure(double d, double d2, int n) {
        return new TargetCenterFigure(d, d2, n);
    }
}

