/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.ot.valdef.ProblemListEvent;
import alma.obsprep.ot.valdef.ProblemListListener;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.Problem;

public class ProblemLogger
implements ProblemListListener {
    private Log.Logger logger = Log.logger((Object)this);
    private boolean started = false;
    private ProblemListModel model;

    public ProblemLogger(ProblemListModel problemListModel) {
        this.model = problemListModel;
    }

    @Override
    public void problemListChanged(ProblemListEvent problemListEvent) {
        switch (problemListEvent.getType()) {
            case 1061: {
                if (!this.started) {
                    this.logger.fine("Starting validation");
                }
                this.started = true;
                break;
            }
            case 1062: {
                if (this.started) {
                    this.logValidationResults();
                    this.logger.fine("Validation finished");
                }
                this.started = false;
                break;
            }
        }
    }

    private void logValidationResults() {
        if (this.model.getSize() == 0) {
            this.logger.info("No validation issues found");
        } else {
            StringBuilder stringBuilder;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < this.model.getSize(); ++i) {
                Problem problem = this.model.getProblemAt(i);
                stringBuilder = new StringBuilder();
                stringBuilder.append(problem.getDescription());
                stringBuilder.append("\n\t");
                stringBuilder.append(problem.getResource());
                stringBuilder.append("\n\t");
                stringBuilder.append(problem.getSuggestion());
                if (problem.isError()) {
                    ++n2;
                    this.logger.fine("Validation Error: " + stringBuilder.toString());
                    continue;
                }
                ++n;
                this.logger.fine("Validation Warning: " + stringBuilder.toString());
            }
            stringBuilder = new StringBuilder();
            stringBuilder.append("Validation found ");
            stringBuilder.append(n2);
            stringBuilder.append(" error");
            if (n2 != 1) {
                stringBuilder.append('s');
            }
            stringBuilder.append(" and ");
            stringBuilder.append(n);
            stringBuilder.append(" warning");
            if (n != 1) {
                stringBuilder.append('s');
            }
            this.logger.info(stringBuilder.toString());
        }
    }
}

