/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.ot.models.sciencegoals.SfiControlParameterModel;
import alma.obsprep.ot.models.sciencegoals.TJDynamicRangeCalculations;
import alma.obsprep.ot.models.sciencegoals.TechnicalJustificationModel;
import alma.obsprep.services.etc.SourceClusterDetector;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationSet;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.experts.MatchedConfiguration;
import alma.obsprep.services.experts.RequiredConfigurations;
import alma.obsprep.services.experts.SchedBlockExpert;
import alma.obsprep.services.experts.ScienceGoalConfigurations;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.util.AngleRange;
import alma.obsprep.util.MiscUtils;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.UserAngle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import lombok.NonNull;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;

public class ConfigurationHelper {
    private static CacheAccess<Integer, MatchedConfiguration> bestMatchCache = JCS.getInstance((String)"bestMatchCache");

    private ConfigurationHelper() {
    }

    public static UserAngle[] determineARRangeForARModeAny(ScienceGoal scienceGoal) {
        Set<Configuration> set = Configuration.getAnyConfigurations();
        OptionalDouble optionalDouble = set.stream().mapToDouble(configuration -> configuration.getMaxBaseline()).max();
        OptionalDouble optionalDouble2 = set.stream().mapToDouble(configuration -> configuration.getMaxBaseline()).min();
        Optional<Configuration> optional = set.stream().filter(configuration -> configuration.getMaxBaseline() == optionalDouble.getAsDouble()).findFirst();
        Optional<Configuration> optional2 = set.stream().filter(configuration -> configuration.getMaxBaseline() == optionalDouble2.getAsDouble()).findFirst();
        Frequency frequency = scienceGoal.getRepresentativeFrequencyInSky();
        assert (optional.isPresent() && optional2.isPresent());
        Angle angle = null;
        Angle angle2 = null;
        ScienceGoal scienceGoal2 = scienceGoal.getParentScienceGoal();
        if (scienceGoal2 == null) {
            scienceGoal2 = scienceGoal;
        }
        try {
            angle = optional.get().getAchievableAngularResolutionForClusters(scienceGoal2, SfiControlParameterModel.RequestAngularResolutionEnum.FINEST, frequency, RequestedArray.TWELVE_M);
            angle2 = optional2.get().getAchievableAngularResolutionForClusters(scienceGoal2, SfiControlParameterModel.RequestAngularResolutionEnum.COARSEST, frequency, RequestedArray.TWELVE_M);
        }
        catch (InvalidConfigurationParametersException | InvalidObsProgramParametersException exception) {
            Log.logger(TechnicalJustificationModel.class).info("Unable to determine AR  : " + exception.getMessage());
        }
        UserAngle userAngle = UserAngle.createUserAngle(angle.getContent(), angle.getUnit(), frequency);
        UserAngle userAngle2 = UserAngle.createUserAngle(angle2.getContent(), angle2.getUnit(), frequency);
        return new UserAngle[]{userAngle2, userAngle};
    }

    public static MatchedConfiguration getBestMatchedConfiguration(double d, @NonNull RequestedArray requestedArray, @NonNull ScienceGoal scienceGoal, ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations, @NonNull Configuration.DesiredAngularResolution desiredAngularResolution, boolean bl) throws InvalidConfigurationParametersException {
        Collection<ScienceGoal> collection;
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("userDefinedSG is marked non-null but is null");
        }
        if (desiredAngularResolution == null) {
            throw new NullPointerException("angularResolutionConstraint is marked non-null but is null");
        }
        if (!EnumSet.of(RequestedArray.SEVEN_M, RequestedArray.TWELVE_M).contains((Object)requestedArray)) {
            throw new IllegalArgumentException("Illegal argument: array must be 12-m or 7-m");
        }
        if (scienceGoalConfigurations.isEmpty()) {
            throw new IllegalArgumentException("Illegal argument: configurationsToBeScheduled.isEmpty() (" + scienceGoalConfigurations.isEmpty() + ") did not pass the test: configurationsToBeScheduled.isEmpty() test");
        }
        Integer n = Objects.hash(new Object[]{d, requestedArray, MiscUtils.getCacheHashcode(false, new BusinessObject[]{scienceGoal}), scienceGoalConfigurations, desiredAngularResolution, bl});
        MatchedConfiguration matchedConfiguration = (MatchedConfiguration)bestMatchCache.get((Object)n);
        if (matchedConfiguration != null) {
            return matchedConfiguration;
        }
        MatchedConfiguration matchedConfiguration2 = new MatchedConfiguration();
        Configuration configuration = null;
        double d2 = Double.POSITIVE_INFINITY;
        SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(scienceGoal);
        try {
            collection = sourceClusterDetector.splitScienceGoalIntoSourceClusters();
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new WizardSBGenerationException(invalidObsProgramParametersException);
        }
        block2: for (ConfigurationSet configurationSet : scienceGoalConfigurations) {
            Optional<Configuration> optional;
            Optional<Configuration> optional2 = requestedArray.equals((Object)RequestedArray.TWELVE_M) ? (bl ? configurationSet.getTM2Configuration() : configurationSet.getTM1Configuration()) : (optional = configurationSet.getAca7mConfiguration());
            if (!optional.isPresent()) {
                throw new IllegalArgumentException("No configuration found");
            }
            for (ScienceGoal scienceGoal2 : collection) {
                Configuration configuration2 = optional.get();
                if (configuration == null) {
                    configuration = configuration2;
                    d2 = configuration2.getAchievableResolution(d, scienceGoal2, requestedArray);
                    continue block2;
                }
                double d3 = configuration2.getAchievableResolution(d, scienceGoal2, requestedArray);
                if (desiredAngularResolution.equals((Object)Configuration.DesiredAngularResolution.FINEST)) {
                    if (!(d3 < d2)) continue;
                    d2 = d3;
                    configuration = configuration2;
                    continue;
                }
                if (!(d3 > d2)) continue;
                d2 = d3;
                configuration = configuration2;
            }
        }
        assert (configuration != null);
        matchedConfiguration2.setConfiguration(Optional.of(configuration));
        matchedConfiguration2.setConfigurationAR(Angle.createAngle((double)d2, (String)Angle.UNIT_ARCSEC));
        bestMatchCache.put((Object)n, (Object)matchedConfiguration2);
        return matchedConfiguration2;
    }

    public static ConfigurationsForResolutionRange getConfigurationsForResolutionRange(double d, RequestedArray requestedArray, @NonNull ScienceGoal scienceGoal, Optional<ReceiverBand> optional, double d2, double d3) throws InvalidConfigurationParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        ConfigurationsForResolutionRange configurationsForResolutionRange = new ConfigurationsForResolutionRange();
        List<Configuration> list = configurationsForResolutionRange.getConfigurations();
        double d4 = (d2 + d3) / 2.0;
        boolean bl = false;
        double d5 = Double.POSITIVE_INFINITY;
        for (Configuration configuration2 : Configuration.getKnownConfigurations(requestedArray)) {
            try {
                boolean bl2;
                if (!configuration2.isReceiverSupported(optional.orElseGet(() -> ReceiverBand.getReceiverBand(d)))) continue;
                Configuration.ARRange aRRange = configuration2.getAchievableResolutionRange(d, scienceGoal, requestedArray);
                double d6 = Math.min(d4 * 0.8, d2);
                double d7 = Math.max(d4 * 1.2, d3);
                boolean bl3 = bl2 = d6 < aRRange.coarsestAR() && d7 > aRRange.finestAR();
                if (bl2) {
                    if (!Configuration.isLongBaselineConfiguration(configuration2)) {
                        bl = true;
                    }
                    list.add(configuration2);
                    continue;
                }
                boolean bl4 = false;
                if (!bl4) continue;
                boolean bl5 = Log.logger(ConfigurationHelper.class).fine();
                if (bl5) {
                    Log.logger(ConfigurationHelper.class).fine("configuration.getName(): " + configuration2.getName());
                    Log.logger(ConfigurationHelper.class).fine("configARRange.finestAR(): " + aRRange.finestAR());
                    Log.logger(ConfigurationHelper.class).fine("configARRange.coarsestAR(): " + aRRange.coarsestAR());
                }
                boolean bl6 = d7 > aRRange.finestAR() && d7 < aRRange.coarsestAR();
                boolean bl7 = d6 > aRRange.finestAR() && d6 < aRRange.coarsestAR();
                double d8 = Double.POSITIVE_INFINITY;
                double d9 = Double.POSITIVE_INFINITY;
                if (!bl7) {
                    if (d6 > aRRange.coarsestAR()) {
                        d8 = aRRange.coarsestAR() - d6;
                    } else if (d6 < aRRange.finestAR()) {
                        d8 = aRRange.finestAR() - d6;
                    }
                }
                if (!bl6) {
                    if (d7 < aRRange.finestAR()) {
                        d9 = aRRange.finestAR() - d7;
                    } else if (d7 > aRRange.coarsestAR()) {
                        d9 = aRRange.coarsestAR() - d7;
                    }
                }
                if (Math.abs(d9) < Math.abs(d5)) {
                    configurationsForResolutionRange.setArRangeLimitClosestToSuitableConfiguration(Optional.of(Configuration.DesiredAngularResolution.COARSEST));
                    d5 = d9;
                    configurationsForResolutionRange.setArToNearestConfiguration(d5);
                    if (bl5) {
                        Log.logger(ConfigurationHelper.class).fine("piCoarsestDelta: " + d9);
                        Log.logger(ConfigurationHelper.class).fine("minARDistanceFromNearestConfiguration: " + d5);
                    }
                }
                if (!(Math.abs(d8) < Math.abs(d5))) continue;
                configurationsForResolutionRange.setArRangeLimitClosestToSuitableConfiguration(Optional.of(Configuration.DesiredAngularResolution.FINEST));
                d5 = d8;
                configurationsForResolutionRange.setArToNearestConfiguration(d5);
                if (!bl5) continue;
                Log.logger(ConfigurationHelper.class).fine("piFinestDelta: " + d8);
                Log.logger(ConfigurationHelper.class).fine("minARDistanceFromNearestConfiguration: " + d5);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidConfigurationParametersException(d);
            }
        }
        if (bl) {
            configurationsForResolutionRange.setConfigurations(list.stream().filter(configuration -> !Configuration.isLongBaselineConfiguration(configuration)).toList());
            if (configurationsForResolutionRange.getConfigurations().size() != list.size()) {
                configurationsForResolutionRange.setLongbaselineConfigurationsTruncated(true);
            }
        }
        return configurationsForResolutionRange;
    }

    public static Angle getAchievableAngularResolutionForAllClusters(@NonNull ScienceGoal scienceGoal, @NonNull SfiControlParameterModel.RequestAngularResolutionEnum requestAngularResolutionEnum, @NonNull Configuration.ConfigurationExtent configurationExtent, @NonNull Frequency frequency, @NonNull RequestedArray requestedArray) throws InvalidObsProgramParametersException, InvalidConfigurationParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (requestAngularResolutionEnum == null) {
            throw new NullPointerException("angularResolutionPerformance is marked non-null but is null");
        }
        if (configurationExtent == null) {
            throw new NullPointerException("configurationExtent is marked non-null but is null");
        }
        if (frequency == null) {
            throw new NullPointerException("repFreq is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(scienceGoal);
        Double d = null;
        block10: for (ScienceGoal scienceGoal2 : sourceClusterDetector.splitScienceGoalIntoSourceClusters()) {
            Configuration configuration = null;
            switch (configurationExtent) {
                case COMPACT: {
                    try {
                        configuration = Configuration.getMostCompactConfiguration(requestedArray);
                        break;
                    }
                    catch (Configuration.UnableToDetermineConfigurationException unableToDetermineConfigurationException) {
                        throw new IllegalArgumentException("Unknown array type " + String.valueOf((Object)requestedArray));
                    }
                }
                case EXTENDED: {
                    configuration = Configuration.getMostExtendedCompatibleConfiguration(requestedArray, scienceGoal);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown configurationExtent specified : " + String.valueOf((Object)configurationExtent));
                }
            }
            assert (configuration != null) : "Configuration should not be null when determining the angular resolution";
            double d2 = configuration.getAchievableResolution(frequency.getContentInGHz(), scienceGoal2, requestedArray);
            if (d == null) {
                d = d2;
                continue;
            }
            switch (requestAngularResolutionEnum) {
                case FINEST: {
                    if (!(d2 < d)) continue block10;
                    d = d2;
                    continue block10;
                }
                case COARSEST: {
                    if (!(d2 > d)) continue block10;
                    d = d2;
                    continue block10;
                }
            }
            throw new RuntimeException("Unable to determine the performance required " + String.valueOf((Object)requestAngularResolutionEnum));
        }
        return Angle.createAngle((double)d, (String)Angle.UNIT_ARCSEC);
    }

    public static Angle getAchievableAngularResolutionForAllClusters(@NonNull ScienceGoal scienceGoal, @NonNull SfiControlParameterModel.RequestAngularResolutionEnum requestAngularResolutionEnum, @NonNull Frequency frequency, Configuration configuration, RequestedArray requestedArray) throws InvalidObsProgramParametersException, InvalidConfigurationParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (requestAngularResolutionEnum == null) {
            throw new NullPointerException("angularResolutionPerformance is marked non-null but is null");
        }
        if (frequency == null) {
            throw new NullPointerException("repFreq is marked non-null but is null");
        }
        SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(scienceGoal);
        Double d = null;
        block4: for (ScienceGoal scienceGoal2 : sourceClusterDetector.splitScienceGoalIntoSourceClusters()) {
            double d2 = configuration.getAchievableResolution(frequency.getContentInGHz(), scienceGoal2, requestedArray);
            if (d == null) {
                d = d2;
                continue;
            }
            switch (requestAngularResolutionEnum) {
                case FINEST: {
                    if (!(d2 < d)) continue block4;
                    d = d2;
                    continue block4;
                }
                case COARSEST: {
                    if (!(d2 > d)) continue block4;
                    d = d2;
                    continue block4;
                }
            }
            throw new RuntimeException("Unable to determine the performance required " + String.valueOf((Object)requestAngularResolutionEnum));
        }
        return Angle.createAngle((double)d, (String)Angle.UNIT_ARCSEC);
    }

    public static AngleRange getARsForConfigsInARRange(ScienceGoal scienceGoal) throws InvalidObsProgramParametersException, InvalidConfigurationParametersException {
        MatchedConfiguration matchedConfiguration = null;
        MatchedConfiguration matchedConfiguration2 = null;
        Frequency frequency = scienceGoal.getPerformanceParameters().getRepresentativeFrequencyWithSkyOffset();
        ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = Configuration.getConfigurationsToBeScheduled(scienceGoal, RequestedArray.TWELVE_M);
        matchedConfiguration = ConfigurationHelper.getBestMatchedConfiguration(frequency.getContentInGHz(), RequestedArray.TWELVE_M, scienceGoal, scienceGoalConfigurations, Configuration.DesiredAngularResolution.COARSEST, false);
        matchedConfiguration2 = ConfigurationHelper.getBestMatchedConfiguration(frequency.getContentInGHz(), RequestedArray.TWELVE_M, scienceGoal, scienceGoalConfigurations, Configuration.DesiredAngularResolution.FINEST, false);
        assert (matchedConfiguration != null && matchedConfiguration2 != null);
        return new AngleRange(matchedConfiguration2.getConfigurationAR(), matchedConfiguration.getConfigurationAR());
    }

    public static boolean isConfigurationInSet(@NonNull Configuration configuration, int ... nArray) {
        if (configuration == null) {
            throw new NullPointerException("configurationToFind is marked non-null but is null");
        }
        if (nArray.length == 0) {
            return false;
        }
        for (int n : nArray) {
            if (configuration.getNumber() != n) continue;
            return true;
        }
        return false;
    }

    public static boolean isConfigurationsScheduled(@NonNull ScienceGoal scienceGoal, @NonNull Set<Configuration.ConfigurationExtent> set, int ... nArray) {
        ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations;
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        if (set == null) {
            throw new NullPointerException("tmArrayTypes is marked non-null but is null");
        }
        try {
            scienceGoalConfigurations = Configuration.getConfigurationsToBeScheduledForAllClusteredScienceGoals(scienceGoal);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            Log.logger(TJDynamicRangeCalculations.class).warning("Unable to determine configurations");
            return false;
        }
        for (ConfigurationSet configurationSet : scienceGoalConfigurations) {
            if (set.contains((Object)Configuration.ConfigurationExtent.EXTENDED) && configurationSet.getTM1Configuration().isPresent() && ConfigurationHelper.isConfigurationInSet(configurationSet.getTM1Configuration().get(), nArray)) {
                return true;
            }
            if (!set.contains((Object)Configuration.ConfigurationExtent.COMPACT) || !configurationSet.getTM2Configuration().isPresent() || !ConfigurationHelper.isConfigurationInSet(configurationSet.getTM2Configuration().get(), nArray)) continue;
            return true;
        }
        return false;
    }

    public static Configuration getMostExtendedConfiguration(@NonNull ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations) throws Configuration.UnableToDetermineConfigurationException {
        if (scienceGoalConfigurations == null) {
            throw new NullPointerException("configurationsScheduled is marked non-null but is null");
        }
        if (scienceGoalConfigurations.isEmpty()) {
            throw new Configuration.UnableToDetermineConfigurationException();
        }
        Configuration configuration = null;
        for (ConfigurationSet configurationSet : scienceGoalConfigurations) {
            Configuration configuration2 = null;
            if (configurationSet.getTM1Configuration().isPresent()) {
                configuration2 = configurationSet.getTM1Configuration().get();
            } else if (configurationSet.getAca7mConfiguration().isPresent()) {
                configuration2 = configurationSet.getAca7mConfiguration().get();
            }
            if (configuration2 == null || configuration != null && !(configuration2.getMaxBaseline() > configuration.getMaxBaseline())) continue;
            configuration = configuration2;
        }
        if (configuration == null) {
            throw new Configuration.UnableToDetermineConfigurationException();
        }
        return configuration;
    }

    public static RequiredConfigurations getRecommended12mConfigurations(ScienceGoal scienceGoal, Frequency frequency) throws InvalidConfigurationParametersException {
        boolean bl;
        Object object;
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        Angle angle = performanceParameters.getDesiredLargestScale();
        RequiredConfigurations requiredConfigurations = new RequiredConfigurations();
        requiredConfigurations.setTMCompactConfigurationRecommended(false);
        try {
            object = scienceGoal.getObsProposal();
            if (object != null && ((ObsProposal)object).isVLBIorPhasedArray()) {
                requiredConfigurations.setBest12mExtConfig(Configuration.getMostCompactConfiguration(RequestedArray.TWELVE_M));
                return requiredConfigurations;
            }
            if (angle.isLessThan((AbstractDoubleWithUnit)Angle.createAngle((double)0.0, (String)Angle.UNIT_ARCMIN))) {
                throw new InvalidConfigurationParametersException("Desired LAS has not been defined");
            }
        }
        catch (UnknownEntityException | Configuration.UnableToDetermineConfigurationException throwable) {
            throw new InvalidConfigurationParametersException("Unable to determine ObsProposal" + String.valueOf(throwable));
        }
        Configuration configuration = Configuration.getBestConfiguration(frequency.getContentInGHz(), RequestedArray.TWELVE_M, scienceGoal);
        requiredConfigurations.setBest12mExtConfig(configuration);
        object = null;
        try {
            bl = scienceGoal.isSolarScienceGoal();
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new InvalidConfigurationParametersException();
        }
        if (bl && !configuration.isConfigurationSolarCompatible(scienceGoal)) {
            String string = "Cannot determine a 12-m configuration for the desired angular resolution of " + String.valueOf(performanceParameters.getDesiredAngularResolution()) + " with a rep. freq of " + String.valueOf((Object)frequency) + " when configured for solar";
            Log.logger(Configuration.class).finer(string);
            throw new InvalidConfigurationParametersException(string);
        }
        if (!bl && angle.isGreaterThan((AbstractDoubleWithUnit)Angle.createAngle((double)0.0, (String)Angle.UNIT_ARCSEC)) && Configuration.getIsSecondConfigurationRequired(configuration, angle.getContentInUnits(Angle.UNIT_ARCSEC), frequency.getContentInGHz(), scienceGoal, RequestedArray.TWELVE_M, false)) {
            requiredConfigurations.setTMCompactConfigurationRecommended(true);
            try {
                object = Configuration.getSecondCompactConfiguration(configuration);
                requiredConfigurations.setTwelveMetreCompactConfig((Configuration)object);
            }
            catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
                Log.logger(SchedBlockExpert.class).finer("Unable to determine the 12m compact configuration when one is required: " + invalidConfigurationParametersException.getMessage());
                requiredConfigurations.setTwelveMetreCompactConfig(null);
            }
        }
        return requiredConfigurations;
    }

    public static class ConfigurationsForResolutionRange {
        private List<Configuration> configurations = new ArrayList<Configuration>();
        private boolean isLongbaselineConfigurationsTruncated = false;
        private Optional<Configuration.DesiredAngularResolution> arRangeLimitClosestToSuitableConfiguration = Optional.empty();
        private double arToNearestConfiguration = 0.0;

        public List<Configuration> getConfigurations() {
            return this.configurations;
        }

        public boolean isLongbaselineConfigurationsTruncated() {
            return this.isLongbaselineConfigurationsTruncated;
        }

        public Optional<Configuration.DesiredAngularResolution> getArRangeLimitClosestToSuitableConfiguration() {
            return this.arRangeLimitClosestToSuitableConfiguration;
        }

        public double getArToNearestConfiguration() {
            return this.arToNearestConfiguration;
        }

        public void setConfigurations(List<Configuration> list) {
            this.configurations = list;
        }

        public void setLongbaselineConfigurationsTruncated(boolean bl) {
            this.isLongbaselineConfigurationsTruncated = bl;
        }

        public void setArRangeLimitClosestToSuitableConfiguration(Optional<Configuration.DesiredAngularResolution> optional) {
            this.arRangeLimitClosestToSuitableConfiguration = optional;
        }

        public void setArToNearestConfiguration(double d) {
            this.arToNearestConfiguration = d;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ConfigurationsForResolutionRange)) {
                return false;
            }
            ConfigurationsForResolutionRange configurationsForResolutionRange = (ConfigurationsForResolutionRange)object;
            if (!configurationsForResolutionRange.canEqual(this)) {
                return false;
            }
            if (this.isLongbaselineConfigurationsTruncated() != configurationsForResolutionRange.isLongbaselineConfigurationsTruncated()) {
                return false;
            }
            if (Double.compare(this.getArToNearestConfiguration(), configurationsForResolutionRange.getArToNearestConfiguration()) != 0) {
                return false;
            }
            List<Configuration> list = this.getConfigurations();
            List<Configuration> list2 = configurationsForResolutionRange.getConfigurations();
            if (list == null ? list2 != null : !((Object)list).equals(list2)) {
                return false;
            }
            Optional<Configuration.DesiredAngularResolution> optional = this.getArRangeLimitClosestToSuitableConfiguration();
            Optional<Configuration.DesiredAngularResolution> optional2 = configurationsForResolutionRange.getArRangeLimitClosestToSuitableConfiguration();
            return !(optional == null ? optional2 != null : !((Object)optional).equals(optional2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof ConfigurationsForResolutionRange;
        }

        public int hashCode() {
            int n = 1;
            n = n * 59 + (this.isLongbaselineConfigurationsTruncated() ? 79 : 97);
            long l = Double.doubleToLongBits(this.getArToNearestConfiguration());
            n = n * 59 + (int)(l >>> 32 ^ l);
            List<Configuration> list = this.getConfigurations();
            n = n * 59 + (list == null ? 43 : ((Object)list).hashCode());
            Optional<Configuration.DesiredAngularResolution> optional = this.getArRangeLimitClosestToSuitableConfiguration();
            n = n * 59 + (optional == null ? 43 : ((Object)optional).hashCode());
            return n;
        }

        public String toString() {
            return "ConfigurationHelper.ConfigurationsForResolutionRange(configurations=" + String.valueOf(this.getConfigurations()) + ", isLongbaselineConfigurationsTruncated=" + this.isLongbaselineConfigurationsTruncated() + ", arRangeLimitClosestToSuitableConfiguration=" + String.valueOf(this.getArRangeLimitClosestToSuitableConfiguration()) + ", arToNearestConfiguration=" + this.getArToNearestConfiguration() + ")";
        }
    }
}

