/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.dgcpostprocessor;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.annotations.BaseBand;
import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.DGCReferenceCalParameters;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.generator.refactored.DGCPostProcessor;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.dgcpostprocessor.DGCObservingParametersFactory;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.valuetypes.DataRate;
import java.util.EnumSet;
import java.util.List;
import lombok.NonNull;

public class BWSWTMDGCParameterConfigurator
implements DGCObservingParametersFactory.DGCParameterConfiguratorInterface {
    @NonNull
    SchedBlock sb;

    @Override
    public void checkDataRates() {
        List<Target> list = this.sb.getAllTargets(DGCReferenceCalParameters.DGCReferenceCalParametersFilter);
        if (list.isEmpty()) {
            return;
        }
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet = this.sb.getSbGenerationContext().getSchemaToUseForSBGeneration();
        if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.MULTIPLE_TUNING)) {
            throw new UnsupportedOperationException("We cannot handle the DGC multiple tuning scenario yet");
        }
        for (Target target : list) {
            SpectralSpec spectralSpec = target.getSpectralSpec();
            AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getCorrelatorConfiguration();
            abstractCorrelatorConfiguration.getDataRateCalculator().updateDataRateForConfig(abstractCorrelatorConfiguration, RequestedArray.TWELVE_M.getControlBlockArray());
            DataRate dataRate = spectralSpec.getInstantaneousDataRate();
            boolean bl = dataRate.isGreaterThan((AbstractDoubleWithUnit)DataRate.createDataRate((double)AlmaPolicies.getInstance().getMax12mDataRateMBPS(), (String)DataRate.UNIT_MB_S));
            if (!bl) continue;
            for (BaseBand baseBand : spectralSpec.getBaseBand()) {
                for (SpectralWindowI spectralWindowI : baseBand.getSpectralWindow()) {
                    spectralWindowI.setSpectralAveragingFactor(spectralWindowI.getSpectralAveragingFactor() * 2);
                }
            }
            Log.logger(DGCPostProcessor.class).fine("Spectral averaging applied to " + spectralSpec.getName() + " " + String.valueOf((Object)spectralSpec.getInstantaneousDataRate()));
        }
    }

    public BWSWTMDGCParameterConfigurator(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        this.sb = schedBlock;
    }
}

