/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.sbbuilder;

import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerator;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.services.generator.refactored.sbbuilder.TPSpectralScanSBGenerator;
import alma.obsprep.services.generator.refactored.sbbuilder.TPStandardSBGenerator;
import lombok.NonNull;

public final class TPSBGeneratorFactory {
    public static final double TP_BEAMWIDTH_SCALING_FACTOR = 1.0;

    public static SBGenerator getTotalPowerSBGenerator(@NonNull SBGenerationContext sBGenerationContext) {
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        if (sBGenerationContext.getSchemaToUseForSBGeneration().contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN)) {
            return new TPSpectralScanSBGenerator(sBGenerationContext);
        }
        return new TPStandardSBGenerator(sBGenerationContext);
    }

    private TPSBGeneratorFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

