/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.sfi;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.util.MiscUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class QuasarFluxDensityCalculator {
    private static QuasarFluxDensityCalculator quasarFluxDensityCalculaterInstance = null;
    private final List<QuasarFluxDensity> quasarFluxDensityList = new ArrayList<QuasarFluxDensity>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static QuasarFluxDensityCalculator getInstance() {
        if (quasarFluxDensityCalculaterInstance != null) return quasarFluxDensityCalculaterInstance;
        Class<QuasarFluxDensityCalculator> clazz = QuasarFluxDensityCalculator.class;
        synchronized (QuasarFluxDensityCalculator.class) {
            if (quasarFluxDensityCalculaterInstance != null) return quasarFluxDensityCalculaterInstance;
            quasarFluxDensityCalculaterInstance = new QuasarFluxDensityCalculator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return quasarFluxDensityCalculaterInstance;
        }
    }

    private QuasarFluxDensityCalculator() {
        this.importQuasarFluxDensityFile();
    }

    private void importQuasarFluxDensityFile() {
        Object object;
        URL uRL = null;
        try {
            object = new File(System.getProperty("otData.dir"));
            assert (object != null);
            uRL = MiscUtils.findResource((File)object, "fluxmaxage730.txt");
        }
        catch (Exception exception) {
            String string = "Error accessing fluxmaxage730.txt file: " + exception.getMessage();
            Log.logger(Configuration.class).warning(string);
            exception.printStackTrace(System.err);
            throw new RuntimeException("Unable to find flux file " + String.valueOf(uRL) + " " + exception.getMessage());
        }
        assert (uRL != null) : "Unable to access flux density files";
        object = null;
        try {
            Log.logger(Configuration.class).fine("Reading flux density file : " + uRL.getFile());
            object = new BufferedReader(new InputStreamReader(uRL.openStream()));
        }
        catch (Exception exception) {
            String string = "Unable to open flux density file : fluxmaxage730.txt: " + exception.getMessage();
            Log.logger(Configuration.class).warning(string);
            throw new RuntimeException(string);
        }
        assert (object != null);
        int n = 0;
        try {
            String string;
            while ((string = ((BufferedReader)object).readLine()) != null) {
                Object object2;
                ++n;
                if ((string = StringUtils.stripToNull((String)string)) == null || StringUtils.startsWith((CharSequence)string, (CharSequence)"#")) continue;
                String[] stringArray = string.replaceAll("\\s+", " ").split(" ");
                if (stringArray.length != 3) {
                    object2 = String.format("Line %d in %s is expected to have three fields, %d found.", n, "fluxmaxage730.txt", stringArray.length);
                    ((BufferedReader)object).close();
                    Log.logger(Configuration.class).warning((String)object2);
                    throw new RuntimeException((String)object2);
                }
                object2 = null;
                Double d = null;
                Double d2 = null;
                try {
                    object2 = Double.valueOf(stringArray[0]);
                    d = Double.valueOf(stringArray[1]);
                    d2 = Double.valueOf(stringArray[2]);
                }
                catch (NumberFormatException numberFormatException) {
                    ((BufferedReader)object).close();
                    String string2 = String.format("Unable to process line %d and convert to real numbers : %s", n, string);
                    Log.logger(Configuration.class).warning(string2);
                    throw new RuntimeException(string2);
                }
                assert (object2 != null && d != null & d2 != null);
                this.quasarFluxDensityList.add(new QuasarFluxDensity(this, (Double)object2, d, d2));
            }
            ((BufferedReader)object).close();
        }
        catch (IOException iOException) {
            Log.logger(Configuration.class).warning("Unable to close file fluxmaxage730.txt: " + iOException.getMessage());
            throw new RuntimeException("Unable to close file : fluxmaxage730.txt");
        }
    }

    public double findQuasarFluxDensityMeasurement(double d, double d2) {
        int n;
        if (d2 < this.quasarFluxDensityList.get((int)0).dec) {
            return this.quasarFluxDensityList.get((int)0).fluxDensity;
        }
        int n2 = this.quasarFluxDensityList.size();
        if (d2 > this.quasarFluxDensityList.get((int)(n2 - 1)).dec) {
            return this.quasarFluxDensityList.get((int)(n2 - 1)).fluxDensity;
        }
        int n3 = 0;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            n = (n4 + n3) / 2;
            QuasarFluxDensity quasarFluxDensity = this.quasarFluxDensityList.get(n);
            if (d2 < quasarFluxDensity.dec) {
                n4 = n - 1;
                continue;
            }
            if (d2 > quasarFluxDensity.dec) {
                n3 = n + 1;
                continue;
            }
            n3 = n4 = n;
            break;
        }
        n = this.quasarFluxDensityList.get((int)n3).dec - d2 < d2 - this.quasarFluxDensityList.get((int)n4).dec ? n3 : n4;
        double d3 = this.quasarFluxDensityList.get((int)n).dec;
        int n5 = n;
        int n6 = n;
        while (n6 >= 0 && this.quasarFluxDensityList.get((int)n6).dec == d3) {
            n5 = n6--;
        }
        n6 = n;
        int n7 = n;
        while (n7 < n2 && this.quasarFluxDensityList.get((int)n7).dec == d3) {
            n6 = n7++;
        }
        n3 = n5;
        n4 = n6;
        while (n3 <= n4) {
            n7 = (n4 + n3) / 2;
            QuasarFluxDensity quasarFluxDensity = this.quasarFluxDensityList.get(n7);
            if (d < quasarFluxDensity.ra) {
                n4 = n7 - 1;
                continue;
            }
            if (d > quasarFluxDensity.ra) {
                n3 = n7 + 1;
                continue;
            }
            n3 = n4 = n7;
            break;
        }
        n7 = this.quasarFluxDensityList.get((int)n3).dec - d2 < d2 - this.quasarFluxDensityList.get((int)n4).dec ? n3 : n4;
        return this.quasarFluxDensityList.get((int)n7).fluxDensity;
    }

    public static void main(String[] stringArray) {
        try {
            InitServices.init();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        QuasarFluxDensityCalculator quasarFluxDensityCalculator = QuasarFluxDensityCalculator.getInstance();
        double d = quasarFluxDensityCalculator.findQuasarFluxDensityMeasurement(268.0, -19.5);
        System.out.println("Nearest flux is " + d);
        d = quasarFluxDensityCalculator.findQuasarFluxDensityMeasurement(280.1, 36.2);
        System.out.println("Nearest flux is " + d);
    }

    private class QuasarFluxDensity
    implements Comparable<QuasarFluxDensity> {
        public double dec;
        public double fluxDensity;
        public double ra;

        public QuasarFluxDensity(QuasarFluxDensityCalculator quasarFluxDensityCalculator, Double d, Double d2, Double d3) {
            this.dec = d2;
            this.fluxDensity = d3;
            this.ra = d;
        }

        @Override
        public int compareTo(QuasarFluxDensity quasarFluxDensity) {
            if (quasarFluxDensity.dec == this.dec) {
                return 0;
            }
            return this.dec < quasarFluxDensity.dec ? -1 : 1;
        }
    }
}

