/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.generator.refactored.MinTuningsCalculator;
import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryParameters;
import alma.obsprep.services.summaryfeedback.VupComparator;
import alma.obsprep.util.VupRange;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.Time;
import alma.valuetypes.UserSensitivity;
import alma.valuetypes.Velocity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class TuningInfo {
    protected List<MinTuningsCalculator.TuningResult> tunings = new ArrayList<MinTuningsCalculator.TuningResult>();
    protected List<String> targetsString = new ArrayList<String>();
    protected SpectralSetupParameters ssp;
    protected List<ScienceSpectralWindow> sortedWindowList;
    protected Map<MinTuningsCalculator.TuningResult, UserSensitivity> rmsAtRepFreq;
    protected Map<MinTuningsCalculator.TuningResult, VupRange<Sensitivity>> achievedRms;

    /*
     * WARNING - void declaration
     */
    public TuningInfo(Collection<MinTuningsCalculator.TuningResult> collection, SpectralSetupParameters spectralSetupParameters, Time time, Angle angle) {
        this.ssp = spectralSetupParameters;
        this.sortedWindowList = spectralSetupParameters.getSortedScienceSpectralWindowList();
        this.rmsAtRepFreq = new HashMap<MinTuningsCalculator.TuningResult, UserSensitivity>();
        this.achievedRms = new HashMap<MinTuningsCalculator.TuningResult, VupRange<Sensitivity>>();
        Comparator comparator = (tuningResult, tuningResult2) -> {
            ScienceGoal scienceGoal = this.ssp.getScienceGoal();
            List<Integer> list = ScienceGoalSummaryParameters.getTargetsIndexList(scienceGoal, tuningResult);
            List<Integer> list2 = ScienceGoalSummaryParameters.getTargetsIndexList(scienceGoal, tuningResult2);
            return list.get(0) - list2.get(0);
        };
        for (MinTuningsCalculator.TuningResult tuningResult3 : collection) {
            this.tunings.add(tuningResult3);
        }
        Collections.sort(this.tunings, comparator);
        ScienceGoal scienceGoal = spectralSetupParameters.getScienceGoal();
        boolean bl = scienceGoal.isStandAloneACA();
        for (MinTuningsCalculator.TuningResult tuningResult4 : this.tunings) {
            void object2;
            Object object;
            Object object3;
            Object object4 = "";
            for (int n : ScienceGoalSummaryParameters.getTargetsIndexList(this.ssp.getScienceGoal(), tuningResult4)) {
                object4 = (String)object4 + String.format("%d,", n + 1);
            }
            this.targetsString.add(((String)object4).substring(0, ((String)object4).length() - 1));
            Object object5 = spectralSetupParameters.getRepresentativeFrequency();
            Velocity velocity = tuningResult4.getKeyTarget().getSourceVelocity();
            Frequency frequency = velocity.dopplerShift((Frequency)((Object)object5));
            try {
                object3 = bl ? Array.ARRAY_7M : Array.ARRAY_12M;
                Sensitivity sensitivity = scienceGoal.getSinglePointOnSourceSensitivity((Array)((Object)object3), time, tuningResult4.getKeyTarget(), frequency);
                object = UserSensitivity.createUserSensitivity(sensitivity.getContent(), sensitivity.getUnit());
                object.setObservingFrequency(frequency);
                object.setBeamsize(angle);
                this.rmsAtRepFreq.put(tuningResult4, (UserSensitivity)object);
            }
            catch (SourceNeverVisibleException | InvalidFrequencyException exception) {
                // empty catch block
            }
            object3 = new ArrayList();
            for (ScienceSpectralWindow scienceSpectralWindow : spectralSetupParameters.getScienceSpectralWindow()) {
                try {
                    Array array = bl ? Array.ARRAY_7M : Array.ARRAY_12M;
                    ((ArrayList)object3).add(scienceGoal.getSinglePointOnSourceSensitivity(array, time, tuningResult4.getKeyTarget(), velocity.dopplerShift(scienceSpectralWindow.getCenterFrequencyRest())));
                }
                catch (SourceNeverVisibleException | InvalidFrequencyException exception) {
                    // empty catch block
                }
            }
            Collections.sort(object3, new VupComparator());
            if (((ArrayList)object3).isEmpty()) {
                Sensitivity sensitivity = Sensitivity.createSensitivity();
                object = Sensitivity.createSensitivity();
            } else {
                Sensitivity sensitivity = (Sensitivity)((Object)((ArrayList)object3).get(0));
                object = (Sensitivity)((Object)((ArrayList)object3).get(((ArrayList)object3).size() - 1));
            }
            this.achievedRms.put(tuningResult4, new VupRange<UserSensitivity>((UserSensitivity)object2, (UserSensitivity)object));
        }
    }

    public int getNumTunings() {
        return this.tunings.size();
    }

    public int getNumSpectralWindows() {
        return this.ssp.getAbstractScienceSpectralWindowScienceSpectralWindowCount();
    }

    public List<MinTuningsCalculator.TuningResult> getTunings() {
        return this.tunings;
    }

    public List<String> getTargetsString() {
        return this.targetsString;
    }

    public SpectralSetupParameters getSsp() {
        return this.ssp;
    }

    public List<ScienceSpectralWindow> getSortedWindowList() {
        return this.sortedWindowList;
    }

    public Map<MinTuningsCalculator.TuningResult, UserSensitivity> getRmsAtRepFreq() {
        return this.rmsAtRepFreq;
    }

    public Map<MinTuningsCalculator.TuningResult, VupRange<Sensitivity>> getAchievedRms() {
        return this.achievedRms;
    }
}

