/*
 * Decompiled with CFR 0.152.
 */
package alma.valuetypes;

import alma.entity.xmlbinding.valuetypes.StorageVolumeT;
import alma.valuetypes.DataRate;
import alma.valuetypes.Time;
import alma.valuetypes.data.StorageVolumeData;

public class StorageVolume
extends StorageVolumeData<StorageVolume> {
    private static final int VISIBILITY_BYTES = 4;
    private static final StorageVolume VISIBILITY_SIZE = StorageVolume.createStorageVolume((double)4.0, (String)UNIT_B);

    public StorageVolume(StorageVolumeT storageVolumeT) {
        super(storageVolumeT);
    }

    public String defaultUnit() {
        return StorageVolume.staticDefaultUnit();
    }

    public static String staticDefaultUnit() {
        return UNIT_MB;
    }

    public StorageVolume times(double d) {
        StorageVolume storageVolume = StorageVolume.createStorageVolume((double)(this.getContent() * d), (String)this.getUnit());
        return storageVolume;
    }

    public DataRate divide(Time time) {
        DataRate dataRate = DataRate.createDataRate();
        double d = this.getContent();
        double d2 = time.getContentInUnits(Time.UNIT_S);
        dataRate.setContent(d / d2);
        dataRate.setUnit(StorageVolume.perSecond(this.getUnit()));
        return dataRate;
    }

    public static StorageVolume getVisibilitySize() {
        return VISIBILITY_SIZE;
    }

    private static String perSecond(String string) {
        String[] stringArray = StorageVolume.getKnownUnitList();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(knownUnitList[i])) continue;
            return DataRate.getKnownUnitList()[i];
        }
        return string + "/s";
    }

    public StorageVolume convertToFriendlyUnit() {
        if (this.isZero()) {
            return this;
        }
        String[] stringArray = StorageVolume.getKnownUnitList();
        for (int i = stringArray.length - 1; i >= 0; --i) {
            if (!(this.getContentInUnits(stringArray[i]) > 1.0)) continue;
            this.convertToUnit(stringArray[i]);
            return this;
        }
        return this;
    }

    public StorageVolume aggregate(StorageVolume storageVolume) {
        double d = storageVolume.getContentInUnits(this.getUnit());
        this.setContent(this.getContent() + d);
        return this;
    }
}

