/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ChangingComboBoxModel
extends DefaultComboBoxModel {
    private final Collection changeListeners_ = new ArrayList();
    private final Collection actionListeners_ = new ArrayList();

    public ChangingComboBoxModel() {
        this(new Object[0]);
    }

    public ChangingComboBoxModel(Object[] items) {
        super(items);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners_.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners_.remove(listener);
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners_.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners_.remove(listener);
    }

    public void setSelectedItem(Object item) {
        Object oldItem = this.getSelectedItem();
        super.setSelectedItem(item);
        if (item == null ? oldItem != null : !item.equals(oldItem)) {
            this.fireSelectionChanged(this);
            this.fireActionPerformed(this);
        }
    }

    protected void fireSelectionChanged(Object source) {
        ChangeEvent evt = new ChangeEvent(source);
        Iterator it = this.changeListeners_.iterator();
        while (it.hasNext()) {
            ChangeListener listener = (ChangeListener)it.next();
            listener.stateChanged(evt);
        }
    }

    protected void fireActionPerformed(Object source) {
        ActionEvent evt = new ActionEvent(source, 0, "change");
        Iterator it = this.actionListeners_.iterator();
        while (it.hasNext()) {
            ActionListener listener = (ActionListener)it.next();
            listener.actionPerformed(evt);
        }
    }
}

