/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry.sampler;

import skyview.geometry.Sampler;

public class Lanczos
extends Sampler {
    private int nLobe;
    private double[] out = new double[2];
    private double coef;
    private double coef2;
    private double[] xw;
    private double[] yw;

    @Override
    public String getName() {
        return "Lanczos" + this.nLobe + " Sampler";
    }

    @Override
    public String getDescription() {
        return "Sample using smoothly truncated sinc kernel";
    }

    @Override
    public void setOrder(int n) {
        this.init(n);
    }

    public Lanczos() {
        this.init(3);
    }

    private void init(int n) {
        this.nLobe = n;
        this.coef = Math.PI / (double)n;
        this.coef2 = this.coef * Math.PI;
        this.xw = new double[2 * n];
        this.yw = new double[2 * n];
    }

    @Override
    public void sample(int pix) {
        double output = 0.0;
        double[] in = this.outImage.getCenter(pix);
        this.trans.transform(in, this.out);
        double x = this.out[0] - 0.5;
        double y = this.out[1] - 0.5;
        int ix = (int)Math.floor(x);
        int iy = (int)Math.floor(y);
        double dx = (double)ix - x - (double)(this.nLobe - 1);
        double dy = (double)iy - y - (double)(this.nLobe - 1);
        if (ix < this.nLobe - 1 || y < (double)(this.nLobe - 1) || ix >= this.inWidth - this.nLobe || iy >= this.inHeight - this.nLobe) {
            return;
        }
        for (int xc = 0; xc < 2 * this.nLobe; ++xc) {
            this.xw[xc] = Math.abs(dx) < 1.0E-10 ? 1.0 : Math.sin(this.coef * dx) * Math.sin(Math.PI * dx) / (this.coef2 * dx * dx);
            dx += 1.0;
        }
        for (int yc = 0; yc < 2 * this.nLobe; ++yc) {
            this.yw[yc] = Math.abs(dy) < 1.0E-10 ? 1.0 : Math.sin(this.coef * dy) * Math.sin(Math.PI * dy) / (this.coef2 * dy * dy);
            dy += 1.0;
        }
        int p = 0;
        boolean pstart = false;
        for (int k = 0; k < this.inDepth; ++k) {
            p = (iy - (this.nLobe - 1)) * this.inWidth + ix - (this.nLobe - 1) + k * this.inWidth * this.inHeight;
            for (int yc = 0; yc < 2 * this.nLobe; ++yc) {
                for (int xc = 0; xc < 2 * this.nLobe; ++xc) {
                    output += this.inImage.getData(p) * this.xw[xc] * this.yw[yc];
                    ++p;
                }
                p += this.inWidth - 2 * this.nLobe;
            }
        }
        this.outImage.setData(pix, output);
    }
}

