/*
 * Decompiled with CFR 0.152.
 */
package skyview.survey;

import java.util.ArrayList;
import skyview.executive.Settings;
import skyview.geometry.Util;
import skyview.survey.ImageGenerator;

public class DSS2ImageGenerator
implements ImageGenerator {
    @Override
    public void getImages(double ra, double dec, double size, ArrayList<String> list) {
        size += Double.parseDouble(Settings.get("imagesize"));
        String dssPrefix = Settings.get("DSS2Prefix");
        if (dssPrefix == null) {
            dssPrefix = "";
        }
        double[][] data = this.surveyCenters(ra, dec, size, 0.25);
        int n = data[0].length;
        for (int i = 0; i < data[0].length; ++i) {
            int sz = 18;
            double delta = Math.abs(Math.abs(dec) - 90.0);
            if (delta < 8.0) {
                sz = 28;
            }
            String spell = "h=" + sz + "&w=" + sz + "&ra=" + data[0][i] + "&dec=" + data[1][i] + "," + dssPrefix + "img" + (int)data[2][i] + ".fits.gz," + data[0][i] + "," + data[1][i];
            list.add(spell);
        }
    }

    private double[][] surveyCenters(double inRA, double inDec, double inSize, double delta) {
        int ndec = (int)(180.0 / delta + 0.5) + 1;
        double ddec = 180.0 / (double)(ndec - 1);
        delta = Math.toRadians(delta);
        ddec = Math.toRadians(ddec);
        double[] decs = new double[ndec];
        int[] nra = new int[ndec];
        int count = 0;
        for (int i = 0; i < ndec; ++i) {
            decs[i] = -1.5707963267948966 + ddec * (double)i;
            nra[i] = (int)(Math.PI * 2 / delta * Math.sin(1.5707963267948966 - decs[i])) + 1;
            count += nra[i];
        }
        inRA = Math.toRadians(inRA);
        inDec = Math.toRadians(inDec);
        inSize = Math.toRadians(inSize);
        double[] ra0 = new double[count];
        double[] dec0 = new double[count];
        double[] ind0 = new double[count];
        int outCount = 0;
        int index = 0;
        for (int iDec = 0; iDec < ndec; ++iDec) {
            int nr = nra[iDec];
            double dRA = Math.PI * 2 / (double)nr;
            double cDec = decs[iDec];
            if (Math.abs(cDec - inDec) < inSize) {
                for (int jRA = 0; jRA < nr; ++jRA) {
                    double cRA = (double)jRA * dRA;
                    if (!(Util.sphdist(cRA, cDec, inRA, inDec) < inSize)) continue;
                    ra0[outCount] = Math.toDegrees(cRA);
                    dec0[outCount] = Math.toDegrees(cDec);
                    ind0[outCount] = index + jRA;
                    ++outCount;
                }
            }
            index += nr;
        }
        double[] ra1 = new double[outCount];
        double[] dec1 = new double[outCount];
        double[] ind1 = new double[outCount];
        System.arraycopy(ra0, 0, ra1, 0, outCount);
        System.arraycopy(dec0, 0, dec1, 0, outCount);
        System.arraycopy(ind0, 0, ind1, 0, outCount);
        return new double[][]{ra1, dec1, ind1};
    }
}

