/*
 * Decompiled with CFR 0.152.
 */
package skyview.survey;

import skyview.Component;
import skyview.geometry.TransformationException;
import skyview.geometry.Transformer;
import skyview.geometry.WCS;

public class Image
implements Component {
    private WCS wcs;
    protected double[] data;
    private int nx;
    private int ny;
    private int nz;
    private String iName = "GenericImage";
    private boolean accumulate;
    private double[] center = new double[2];
    private double[][] corners = new double[2][4];

    public Image() {
    }

    @Override
    public String getName() {
        return this.iName;
    }

    protected void setName(String name) {
        this.iName = name;
    }

    @Override
    public String getDescription() {
        return "A set of pixel values along with a description of where in the sky they come from.";
    }

    public Image(double[] data, WCS wcs, int width, int height) throws TransformationException {
        this.initialize(data, wcs, width, height, 1);
    }

    public Image(double[] data, WCS wcs, int width, int height, int depth) throws TransformationException {
        this.initialize(data, wcs, width, height, depth);
    }

    public void initialize(double[] data, WCS wcs, int width, int height, int depth) throws TransformationException {
        this.data = data;
        this.wcs = wcs;
        this.nx = width;
        this.ny = height;
        this.nz = depth;
    }

    public WCS getWCS() {
        return this.wcs;
    }

    public double getData(int npix) {
        return this.data[npix];
    }

    public double[] getDataArray() {
        return this.data;
    }

    public void setAccumulate(boolean flag) {
        this.accumulate = flag;
    }

    public void setData(int npix, double newData) {
        if (this.data == null) {
            this.data = new double[this.nx * this.ny * this.nz];
        }
        if (this.accumulate) {
            int n = npix;
            this.data[n] = this.data[n] + newData;
        } else {
            this.data[npix] = newData;
        }
    }

    public void clearData() {
        this.data = null;
    }

    public void setDataArray(double[] newData) {
        this.data = newData;
    }

    public Transformer getTransformer() {
        return this.wcs;
    }

    public int getWidth() {
        return this.nx;
    }

    public int getHeight() {
        return this.ny;
    }

    public int getDepth() {
        return this.nz;
    }

    public double[] getCenter(int npix) {
        this.center[0] = (double)(npix % this.nx) + 0.5;
        this.center[1] = (double)(npix / this.nx) + 0.5;
        return this.center;
    }

    public double[][] getCorners(int npix) {
        this.corners[0][0] = npix % this.nx;
        this.corners[1][0] = npix / this.nx;
        this.corners[0][1] = this.corners[0][0] + 1.0;
        this.corners[1][1] = this.corners[1][0];
        this.corners[0][2] = this.corners[0][1];
        this.corners[1][2] = this.corners[1][0] + 1.0;
        this.corners[0][3] = this.corners[0][0];
        this.corners[1][3] = this.corners[1][2];
        return this.corners;
    }

    public void validate() {
    }

    public boolean valid() {
        return true;
    }

    public boolean isTiled() {
        return false;
    }

    public Image getBaseImage() {
        return this;
    }
}

