/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingbinding.adapters;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class BeanAdapterBase {
    protected final String property;
    private PropertyChangeSupport support;

    protected BeanAdapterBase(String property) {
        assert (property != null);
        this.property = property.intern();
    }

    protected void listeningStarted() {
    }

    protected void listeningStopped() {
    }

    protected final boolean isListening() {
        return this.support == null ? false : this.support.getPropertyChangeListeners().length > 0;
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        boolean wasListening = this.isListening();
        if (this.support == null) {
            this.support = new PropertyChangeSupport(this);
        }
        this.support.addPropertyChangeListener(listener);
        if (!wasListening) {
            this.listeningStarted();
        }
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.support == null) {
            return;
        }
        boolean wasListening = this.isListening();
        this.support.removePropertyChangeListener(listener);
        if (wasListening && !this.isListening()) {
            this.listeningStopped();
        }
    }

    public final PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.support == null) {
            return new PropertyChangeListener[0];
        }
        return this.support.getPropertyChangeListeners();
    }

    public final void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        if (listener == null || property == null || property.intern() != this.property) {
            return;
        }
        boolean wasListening = this.isListening();
        if (this.support == null) {
            this.support = new PropertyChangeSupport(this);
        }
        this.support.addPropertyChangeListener(property, listener);
        if (!wasListening) {
            this.listeningStarted();
        }
    }

    public final void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        if (listener == null || this.support == null || property == null || property.intern() != this.property) {
            return;
        }
        boolean wasListening = this.isListening();
        this.support.removePropertyChangeListener(property, listener);
        if (wasListening && !this.isListening()) {
            this.listeningStopped();
        }
    }

    public final PropertyChangeListener[] getPropertyChangeListeners(String property) {
        if (this.support == null || property == null || property.intern() != this.property) {
            return new PropertyChangeListener[0];
        }
        return this.support.getPropertyChangeListeners(property);
    }

    protected final void firePropertyChange(Object oldValue, Object newValue) {
        if (this.support == null) {
            return;
        }
        this.support.firePropertyChange(this.property, oldValue, newValue);
    }
}

