/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot.BarStyle;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot.StyleSet;
import uk.ac.starlink.ttools.plot.Styles;

public class BarStyles {
    public static StyleSet filled(String name) {
        return new AutoBarStyleSet(name, true, false, BarStyle.FORM_FILLED, BarStyle.PLACE_OVER);
    }

    public static StyleSet filled3d(String name) {
        return new AutoBarStyleSet(name, true, false, BarStyle.FORM_FILLED3D, BarStyle.PLACE_OVER);
    }

    public static StyleSet open(String name, boolean rotateColor, boolean rotateDash) {
        return new AutoBarStyleSet(name, rotateColor, rotateDash, BarStyle.FORM_OPEN, BarStyle.PLACE_OVER);
    }

    public static StyleSet tops(String name, boolean rotateColor, boolean rotateDash) {
        return new AutoBarStyleSet(name, rotateColor, rotateDash, BarStyle.FORM_TOP, BarStyle.PLACE_OVER);
    }

    public static StyleSet spikes(String name, boolean rotateColor, boolean rotateDash) {
        return new AutoBarStyleSet(name, rotateColor, rotateDash, BarStyle.FORM_SPIKE, BarStyle.PLACE_ADJACENT);
    }

    public static StyleSet sideFilled(String name) {
        return new AutoBarStyleSet(name, true, false, BarStyle.FORM_FILLED, BarStyle.PLACE_ADJACENT);
    }

    public static StyleSet sideFilled3d(String name) {
        return new AutoBarStyleSet(name, true, false, BarStyle.FORM_FILLED3D, BarStyle.PLACE_ADJACENT);
    }

    public static StyleSet sideOpen(String name, boolean rotateColor, boolean rotateDash) {
        return new AutoBarStyleSet(name, rotateColor, rotateDash, BarStyle.FORM_OPEN, BarStyle.PLACE_ADJACENT);
    }

    public static Icon getIcon(final StyleSet styleSet) {
        int height = 16;
        final double[][] data = new double[][]{{0.0, 4.0, 7.0, 12.0, 15.0, 9.0, 0.0}, {0.0, 2.0, 6.0, 8.0, 9.0, 3.0, 0.0}};
        final int nSet = data.length;
        final int nBar = data[0].length - 2;
        final int barWidth = nSet * 7;
        return new Icon(){

            public int getIconHeight() {
                return 16;
            }

            public int getIconWidth() {
                return nBar * barWidth;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                for (int iset = 0; iset < nSet; ++iset) {
                    for (int ibar = 0; ibar < nBar; ++ibar) {
                        int lastDatum = (int)data[iset][ibar];
                        int datum = (int)data[iset][ibar + 1];
                        int nextDatum = (int)data[iset][ibar + 2];
                        BarStyle style = (BarStyle)styleSet.getStyle(iset);
                        int xlo = x + ibar * barWidth;
                        int xhi = xlo + barWidth;
                        int ylo = 16 - datum;
                        int lastYlo = y + 16 - lastDatum;
                        int nextYlo = y + 16 - nextDatum;
                        int yhi = y + 16;
                        if (ibar == 0) {
                            style.drawEdge(g, xlo, ylo, lastYlo, iset, nSet);
                        }
                        style.drawBar(g, xlo, xhi, ylo, yhi, iset, nSet);
                        style.drawEdge(g, xhi, ylo, nextYlo, iset, nSet);
                    }
                }
            }
        };
    }

    public static Icon getIcon(BarStyle.Form form) {
        int height = 16;
        final double[] data = new double[]{0.0, 4.0, 7.0, 12.0, 15.0, 9.0, 0.0};
        final int nBar = data.length - 2;
        int barWidth = 10;
        final BarStyle style = new BarStyle(Color.BLACK, form, BarStyle.PLACE_OVER);
        return new Icon(){

            public int getIconHeight() {
                return 16;
            }

            public int getIconWidth() {
                return nBar * 10;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                for (int ibar = 0; ibar < nBar; ++ibar) {
                    int lastDatum = (int)data[ibar];
                    int datum = (int)data[ibar + 1];
                    int nextDatum = (int)data[ibar + 2];
                    int xlo = x + ibar * 10;
                    int xhi = xlo + 10;
                    int ylo = y + 16 - datum;
                    int lastYlo = y + 16 - lastDatum;
                    int nextYlo = y + 16 - nextDatum;
                    int yhi = y + 16;
                    if (ibar == 0) {
                        style.drawEdge(g, xlo, ylo, lastYlo, 0, 1);
                    }
                    style.drawBar(g, xlo, xhi, ylo, yhi, 0, 1);
                    style.drawEdge(g, xhi, ylo, nextYlo, 0, 1);
                }
            }
        };
    }

    private static class AutoBarStyleSet
    implements StyleSet {
        private final String name_;
        private final boolean rotateColor_;
        private final boolean rotateDash_;
        private final BarStyle.Form form_;
        private final BarStyle.Placement placement_;

        protected AutoBarStyleSet(String name, boolean rotateColor, boolean rotateDash, BarStyle.Form form, BarStyle.Placement placement) {
            this.name_ = name;
            this.rotateColor_ = rotateColor;
            this.rotateDash_ = rotateDash;
            this.form_ = form;
            this.placement_ = placement;
        }

        public String getName() {
            return this.name_;
        }

        public Style getStyle(int index) {
            Color color = this.rotateColor_ ? Styles.getColor(index) : Styles.PLAIN_COLOR;
            BarStyle style = new BarStyle(color, this.form_, this.placement_);
            style.setDash(this.rotateDash_ ? Styles.getDash(index) : Styles.getDash(0));
            return style;
        }
    }
}

