/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plottask;

import java.awt.Color;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.IntegerParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.plot.BarStyle;
import uk.ac.starlink.ttools.plot.BarStyles;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot.StyleSet;
import uk.ac.starlink.ttools.plottask.ColorParameter;
import uk.ac.starlink.ttools.plottask.DashParameter;
import uk.ac.starlink.ttools.plottask.StyleFactory;
import uk.ac.starlink.ttools.plottask.StyleParameter;

public class BarStyleFactory
extends StyleFactory {
    private final StyleSet styleSet_ = BarStyles.sideFilled("Filled");

    public BarStyleFactory(String prefix) {
        super(prefix);
    }

    public Parameter[] getParameters(String stSuffix) {
        return new Parameter[]{this.createColorParameter(stSuffix), this.createShapeParameter(stSuffix), this.createLineWidthParameter(stSuffix), this.createDashParameter(stSuffix)};
    }

    public Style getStyle(Environment env, String stSuffix) throws TaskException {
        BarStyle style0 = (BarStyle)this.styleSet_.getStyle(this.getStyleIndex(stSuffix));
        ChoiceParameter shapeParam = this.createShapeParameter(stSuffix);
        shapeParam.setDefaultOption((Object)new BarShape(style0.getForm(), style0.getPlacement()));
        BarShape shape = (BarShape)shapeParam.objectValue(env);
        ColorParameter colorParam = this.createColorParameter(stSuffix);
        colorParam.setDefaultColor(style0.getColor());
        Color color = colorParam.colorValue(env);
        BarStyle style = new BarStyle(color, shape.form_, shape.placement_);
        IntegerParameter lineParam = this.createLineWidthParameter(stSuffix);
        lineParam.setDefault(Integer.toString(style0.getLineWidth()));
        style.setLineWidth(lineParam.intValue(env));
        DashParameter dashParam = this.createDashParameter(stSuffix);
        dashParam.setDefaultOption(style0.getDash());
        style.setDash(dashParam.dashValue(env));
        return style;
    }

    private ColorParameter createColorParameter(String stSuffix) {
        ColorParameter param = new ColorParameter(this.paramName("colour", stSuffix));
        param.setPrompt("Bar colour for data set " + stSuffix);
        param.setDescription(new String[]{"<p>Defines the colour of bars plotted for data set", stSuffix + ".", param.getFormatDescription(), "</p>", "<p>For most purposes, either the American or the British spelling", "is accepted for this parameter name.", "</p>"});
        return param;
    }

    private ChoiceParameter createShapeParameter(String stSuffix) {
        StyleParameter param = new StyleParameter(this.paramName("barstyle", stSuffix));
        param.addOption(new BarShape(BarStyle.FORM_FILLED, BarStyle.PLACE_ADJACENT), "fill");
        param.addOption(new BarShape(BarStyle.FORM_OPEN, BarStyle.PLACE_ADJACENT), "open");
        param.addOption(new BarShape(BarStyle.FORM_TOP, BarStyle.PLACE_OVER), "tops");
        param.addOption(new BarShape(BarStyle.FORM_SPIKE, BarStyle.PLACE_ADJACENT), "spikes");
        param.addOption(new BarShape(BarStyle.FORM_FILLED, BarStyle.PLACE_OVER), "fillover");
        param.addOption(new BarShape(BarStyle.FORM_OPEN, BarStyle.PLACE_OVER), "openover");
        param.setDefault("fill");
        param.setPrompt("Histogram bar style for dataset " + stSuffix);
        param.setDescription(new String[]{"<p>Defines how histogram bars will be drawn for dataset", stSuffix + ".", "The options are:", param.getOptionList(), "</p>"});
        return param;
    }

    private IntegerParameter createLineWidthParameter(String stSuffix) {
        IntegerParameter param = new IntegerParameter(this.paramName("linewidth", stSuffix));
        param.setPrompt("Line width for lines in dataset " + stSuffix);
        param.setDescription(new String[]{"<p>Defines the line width for lines drawn as part of the bars", "for dataset " + stSuffix + ".", "Only certain bar styles are affected by the line width.", "</p>"});
        param.setDefault(Integer.toString(2));
        param.setMinimum(1);
        return param;
    }

    private DashParameter createDashParameter(String stSuffix) {
        DashParameter param = new DashParameter(this.paramName("dash", stSuffix));
        param.setPrompt("Dash pattern for lines in dataset " + stSuffix);
        param.setDescription(new String[]{"<p>Defines the dashing pattern for lines drawn for dataset", stSuffix + ".", param.getFormatDescription(), "Only certain bar styles are affected by the dash pattern.", "</p>"});
        return param;
    }

    private static class BarShape {
        final BarStyle.Form form_;
        final BarStyle.Placement placement_;

        BarShape(BarStyle.Form form, BarStyle.Placement placement) {
            this.form_ = form;
            this.placement_ = placement;
        }

        public int hashCode() {
            return this.form_.hashCode() + 100 * this.placement_.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof BarShape) {
                BarShape other = (BarShape)o;
                return this.form_.equals(other.form_) && this.placement_.equals(other.placement_);
            }
            return false;
        }
    }
}

