/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plottask;

import java.awt.Color;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.plottask.NamedObjectParameter;

public class ColorParameter
extends NamedObjectParameter {
    public ColorParameter(String name) {
        super(name);
        this.setUsage("<rrggbb>|red|blue|...");
        this.addOption("red", new Color(0xF00000));
        this.addOption("blue", new Color(240));
        this.addOption("green", Color.green.darker());
        this.addOption("grey", Color.gray);
        this.addOption("magenta", Color.magenta);
        this.addOption("cyan", Color.cyan.darker());
        this.addOption("orange", Color.orange);
        this.addOption("pink", Color.pink);
        this.addOption("yellow", Color.yellow);
        this.addOption("black", Color.black);
        this.addOption("white", Color.white);
    }

    public Color colorValue(Environment env) throws TaskException {
        return (Color)this.objectValue(env);
    }

    public void setDefaultColor(Color color) {
        this.setDefaultOption(color);
    }

    public String toString(Object option) {
        return Integer.toString(((Color)option).getRGB() & 0xFFFFFF, 16);
    }

    public Object fromString(String name) {
        return new Color(Integer.parseInt(name, 16));
    }

    public String getFormatDescription() {
        StringBuffer sbuf = new StringBuffer().append("The value may be a 6-digit hexadecimal number giving\n").append("red, green and blue intensities,\n").append("e.g. \"<code>ff00ff</code>\" for magenta.\n").append("Alternatively it may be the name of one of the\n").append("pre-defined colours.\n").append("These are currently\n");
        String[] names = this.getNames();
        for (int i = 0; i < names.length; ++i) {
            if (i == names.length - 1) {
                sbuf.append(" and ");
            } else if (i > 0) {
                sbuf.append(", ");
            }
            sbuf.append(names[i]);
        }
        sbuf.append(".");
        return sbuf.toString();
    }
}

