/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.ExecutionException;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.task.ChoiceMode;
import uk.ac.starlink.ttools.task.ConsumerTask;
import uk.ac.starlink.ttools.task.TableProducer;
import uk.ac.starlink.vo.RegistryQuery;
import uk.ac.starlink.vo.RegistryStarTable;

public class RegQuery
extends ConsumerTask {
    private final Parameter queryParam_;
    private final Parameter urlParam_;
    private static final String ALL_RECORDS = "ALL";

    public RegQuery() {
        super("Queries the VO registry", new ChoiceMode(), true);
        ArrayList<Parameter> paramList = new ArrayList<Parameter>();
        this.queryParam_ = new Parameter("query");
        this.queryParam_.setPrompt("Text of registry query");
        this.queryParam_.setDescription(new String[]{"<p>Text of an ADQL WHERE clause targeted at the", "<webref url='http://www.ivoa.net/Documents/cover/VOResource-20080222.html'>VOResource 1.0</webref>", "schema defining which resource records", "you wish to retrieve from the registry.", "Some examples are:", "<ul>", "<li><code>@xsi:type like '%Organisation%'</code></li>", "<li><code>capability/@standardID = 'ivo://ivoa.net/std/ConeSearch' and title like '%SDSS%'</code></li>", "<li><code>curation/publisher like 'CDS%' and title like '%galax%'</code></li>", "</ul>", "</p>", "<p>A full description of ADQL syntax and of the VOResource schema", "is well beyond the scope of this", "documentation, but in general you want to use", "<code>&lt;field-name&gt; like '&lt;value&gt;'</code>", "where '<code>%</code>' is a wildcard character.", "Logical operators <code>and</code> and <code>or</code> and", "parentheses can be used to group and combine expressions.", "To work out the various <code>&lt;field-name&gt;</code>s", "you need to look at the VOResource 1.0 schema;", "you can find some more discussion in the documentation of the", "NVO <webref url='http://trac.us-vo.org/project/nvo/wiki/IVOARegistry'>IVOARegistry</webref> package.", "</p>"});
        paramList.add(this.queryParam_);
        this.urlParam_ = new Parameter("regurl");
        this.urlParam_.setPrompt("URL of registry service");
        this.urlParam_.setDefault(RegistryQuery.AG_REG);
        this.urlParam_.setDescription(new String[]{"<p>The URL of a SOAP endpoint which provides", "a VOResource1.0 IVOA registry service.", "</p>"});
        paramList.add(this.urlParam_);
        this.getParameterList().addAll(0, paramList);
    }

    protected TableProducer createProducer(Environment env) throws TaskException {
        URL regURL;
        String queryText = this.queryParam_.stringValue(env);
        if (ALL_RECORDS.toUpperCase().equals(queryText.trim().toUpperCase())) {
            queryText = null;
        }
        String urlText = this.urlParam_.stringValue(env);
        try {
            regURL = new URL(urlText);
        }
        catch (MalformedURLException e) {
            throw new ParameterValueException(this.urlParam_, "Bad URL: " + urlText, (Throwable)e);
        }
        final RegistryQuery query = new RegistryQuery(regURL.toString(), queryText);
        return new TableProducer(){

            public StarTable getTable() throws TaskException {
                try {
                    return new RegistryStarTable(query);
                }
                catch (Exception e) {
                    throw new ExecutionException("Query failed: " + e.getMessage(), (Throwable)e);
                }
            }
        };
    }
}

