/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.vmtools;

import alma.acs.vmtools.LogManagerGui;
import alma.acs.vmtools.SysPropEditor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class Launcher {
    Class[] toolClasses = new Class[]{LogManagerGui.class, SysPropEditor.class};
    protected JFrame launcherFrame = this.createFrame("Acs VmTools");

    public static void main(String[] args) {
        if (args.length == 0) {
            Launcher.errorStop("No application specified: Give application class as first argument");
        }
        try {
            new Launcher();
        }
        catch (Throwable exc) {
            Launcher.error("Failed to start VmTools Launcher: " + exc);
        }
        Launcher.launchApplication(args);
    }

    static void launchApplication(String[] args) {
        String applicationClass = args[0];
        String[] applicationArgs = new String[args.length - 1];
        System.arraycopy(args, 1, applicationArgs, 0, applicationArgs.length);
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> c = Class.forName(applicationClass, true, cl);
            Method main = c.getDeclaredMethod("main", String[].class);
            Object applicationInst = c.newInstance();
            main.invoke(applicationInst, new Object[]{applicationArgs});
        }
        catch (Exception exc) {
            exc.printStackTrace();
            Launcher.errorStop("Failed to run class '" + applicationClass + "': " + exc);
        }
    }

    private static void errorStop(String message) {
        String me = Launcher.class.getName();
        System.err.println(me + ": Stop. " + message);
        System.exit(1);
    }

    private static void error(String message) {
        String me = Launcher.class.getName();
        System.err.println(me + ": " + message);
    }

    public Launcher() {
        JPanel buttons = new JPanel();
        for (int i = 0; i < this.toolClasses.length; ++i) {
            Class toolClass = this.toolClasses[i];
            String toolClassName = toolClass.getName();
            try {
                String toolName = toolClassName.substring(toolClassName.lastIndexOf(46) + 1);
                if (JComponent.class.isAssignableFrom(toolClass)) {
                    JButton btn = this.createButton(toolName, toolClass);
                    buttons.add(btn);
                    continue;
                }
                Launcher.error("Won't add '" + toolClassName + "' to VmTools Launcher: Only descendants of JComponent can be added");
                continue;
            }
            catch (Exception e) {
                Launcher.error("Failed to add '" + toolClassName + "' to VmTools Launcher");
            }
        }
        this.launcherFrame.getContentPane().add(buttons);
        this.launcherFrame.pack();
        this.launcherFrame.setVisible(true);
    }

    protected JFrame createFrame(String title) {
        final JFrame ret = new JFrame(title);
        ret.setDefaultCloseOperation(0);
        ret.addWindowListener(new WindowAdapter(this){

            @Override
            public void windowClosing(WindowEvent evt) {
                int answer = JOptionPane.showConfirmDialog(ret, "Really close Acs VmTools?", "Close Window", 0);
                if (answer == 0) {
                    ret.setVisible(false);
                    ret.dispose();
                }
            }
        });
        return ret;
    }

    protected JButton createButton(String toolName, Class toolClass) {
        JButton ret = new JButton(toolName);
        ret.setToolTipText("Start " + toolName);
        class ToolStarter
        implements ActionListener {
            protected String toolName;
            protected Class toolClass;
            protected JComponent toolInstance;
            protected JDialog toolWindow;

            protected ToolStarter(String toolName, Class toolClass) {
                this.toolName = toolName;
                this.toolClass = toolClass;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (this.toolInstance == null) {
                    try {
                        this.toolInstance = (JComponent)this.toolClass.newInstance();
                    }
                    catch (Exception exc) {
                        Launcher.error("Failed to launch tool '" + this.toolName + "': " + exc);
                        return;
                    }
                    this.toolWindow = new JDialog(Launcher.this.launcherFrame, this.toolName, false);
                    this.toolWindow.setDefaultCloseOperation(2);
                    this.toolWindow.getContentPane().add(this.toolInstance);
                }
                this.toolWindow.setVisible(true);
            }
        }
        ToolStarter ts = new ToolStarter(toolName, toolClass);
        ret.addActionListener(ts);
        return ret;
    }
}

