/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.dialogs.main;

import alma.acs.logging.table.LogEntryTable;
import com.cosylab.logging.engine.log.LogTypeHelper;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class LogNavigationBar
extends JToolBar
implements ActionListener {
    private JButton beginBtn;
    private JButton endBtn;
    private JButton prevBtn;
    private JButton nextBtn;
    private JButton selectedBtn;
    private JButton searchBtn;
    private LogEntryTable table;

    public LogNavigationBar(LogEntryTable table) {
        if (table == null) {
            throw new IllegalArgumentException("The table can't be null");
        }
        this.initialize();
        this.table = table;
    }

    private void initialize() {
        this.setFloatable(true);
        JPanel toolBarPanel = new JPanel();
        toolBarPanel.setLayout(new FlowLayout(0));
        this.beginBtn = new JButton(new ImageIcon(this.getClass().getResource("/begin.png")));
        this.beginBtn.setToolTipText("To beginning");
        toolBarPanel.add(this.beginBtn);
        this.prevBtn = new JButton(new ImageIcon(this.getClass().getResource("/prev.png")));
        this.prevBtn.setToolTipText("To prev");
        toolBarPanel.add(this.prevBtn);
        this.nextBtn = new JButton(new ImageIcon(this.getClass().getResource("/next.png")));
        this.nextBtn.setToolTipText("To next");
        toolBarPanel.add(this.nextBtn);
        this.endBtn = new JButton(new ImageIcon(this.getClass().getResource("/end.png")));
        this.endBtn.setToolTipText("To end");
        toolBarPanel.add(this.endBtn);
        toolBarPanel.add(new JToolBar.Separator());
        this.selectedBtn = new JButton(new ImageIcon(this.getClass().getResource("/selected.png")));
        this.selectedBtn.setToolTipText("To selected");
        toolBarPanel.add(this.selectedBtn);
        ImageIcon searchIcon = new ImageIcon(LogTypeHelper.class.getResource("/search.png"));
        this.searchBtn = new JButton("<HTML><FONT size=-2>Search...</FONT>", searchIcon);
        this.searchBtn.setToolTipText("Search logs");
        toolBarPanel.add(this.searchBtn);
        this.add(toolBarPanel);
        this.beginBtn.addActionListener(this);
        this.prevBtn.addActionListener(this);
        this.nextBtn.addActionListener(this);
        this.endBtn.addActionListener(this);
        this.selectedBtn.addActionListener(this);
    }

    public void setEventHandler(ActionListener listener) {
        this.searchBtn.addActionListener(listener);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.beginBtn.setEnabled(enabled);
        this.prevBtn.setEnabled(enabled);
        this.nextBtn.setEnabled(enabled);
        this.endBtn.setEnabled(enabled);
        this.selectedBtn.setEnabled(enabled);
        this.searchBtn.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public JButton getSearchBtn() {
        return this.searchBtn;
    }

    public JButton getBeginBtn() {
        return this.beginBtn;
    }

    public JButton getEndBtn() {
        return this.endBtn;
    }

    public JButton getPrevBtn() {
        return this.prevBtn;
    }

    public JButton getNextBtn() {
        return this.nextBtn;
    }

    public JButton getSelectedBtn() {
        return this.selectedBtn;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.prevBtn) {
            this.table.scrollToPrevSelectedRow();
        } else if (e.getSource() == this.nextBtn) {
            this.table.scrollToNextSelectedRow();
        } else if (e.getSource() == this.beginBtn) {
            this.table.scrollToFirstRow();
        } else if (e.getSource() == this.endBtn) {
            this.table.scrollToLastRow();
        } else if (e.getSource() == this.selectedBtn) {
            this.table.scrollToSelectedRow();
        }
    }
}

