/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RowEntries {
    private final List<Integer> entries = Collections.synchronizedList(new ArrayList(20000));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> removeLastEntries(int numOfEntries) {
        if (numOfEntries <= 0) {
            throw new IllegalArgumentException("Invalid number of entries to remove: " + numOfEntries);
        }
        ArrayList<Integer> temp = new ArrayList<Integer>();
        List<Integer> list = this.entries;
        synchronized (list) {
            for (int t = 0; t < numOfEntries; ++t) {
                temp.add(this.entries.get(0));
                this.entries.remove(0);
            }
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> removeFirstEntries(int numOfEntries) {
        if (numOfEntries <= 0) {
            throw new IllegalArgumentException("Invalid number of entries to remove: " + numOfEntries);
        }
        ArrayList<Integer> temp = new ArrayList<Integer>();
        List<Integer> list = this.entries;
        synchronized (list) {
            for (int t = 0; t < numOfEntries && !this.entries.isEmpty(); ++t) {
                temp.add(this.entries.get(this.entries.size() - 1));
                this.entries.remove(this.entries.size() - 1);
            }
        }
        return temp;
    }

    public int size() {
        return this.entries.size();
    }

    public void add(Integer key) {
        this.entries.add(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer get(int row) {
        List<Integer> list = this.entries;
        synchronized (list) {
            int indxInTheList = this.entries.size() - 1 - row;
            return this.entries.get(indxInTheList);
        }
    }

    public void clear() {
        this.entries.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Integer key) {
        List<Integer> list = this.entries;
        synchronized (list) {
            int pos = this.entries.indexOf(key);
            return pos == -1 ? pos : this.entries.size() - pos - 1;
        }
    }
}

