/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.logging;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class TransparentGlassPane
extends JComponent
implements MouseListener {
    private final Container contentPane;
    private Component mouseEvtComponent = null;

    public TransparentGlassPane(Container c) {
        this.contentPane = c;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        g2D.setColor(Color.black);
        g2D.setComposite(AlphaComposite.getInstance(3, 0.05f));
        g2D.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.redispatchMouseEvent(e, true);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.redispatchMouseEvent(e, true);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.redispatchMouseEvent(e, true);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.redispatchMouseEvent(e, true);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.redispatchMouseEvent(e, true);
    }

    private void redispatchMouseEvent(MouseEvent e, boolean repaint) {
        Point glassPanePoint = e.getPoint();
        Container container = this.contentPane;
        Point containerPoint = SwingUtilities.convertPoint(this, glassPanePoint, this.contentPane);
        if (containerPoint.y >= 0) {
            Component component = SwingUtilities.getDeepestComponentAt(container, containerPoint.x, containerPoint.y);
            if (component == null) {
                return;
            }
            if (this.mouseEvtComponent == null || component.equals(this.mouseEvtComponent)) {
                Point componentPoint = SwingUtilities.convertPoint(this, glassPanePoint, component);
                component.dispatchEvent(new MouseEvent(component, e.getID(), e.getWhen(), e.getModifiers(), componentPoint.x, componentPoint.y, e.getClickCount(), e.isPopupTrigger()));
            }
        }
    }

    public void setVisible(boolean b, Component comp) {
        this.setEventComponent(comp);
        super.setVisible(b);
    }

    public void setEventComponent(Component comp) {
        this.mouseEvtComponent = comp;
        if (comp == null) {
            this.removeMouseListener(this);
        } else {
            this.addMouseListener(this);
        }
    }
}

