/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.logging.client.cache;

import com.cosylab.logging.client.cache.ILogMap;
import com.cosylab.logging.client.cache.LogCacheException;
import com.cosylab.logging.client.cache.LogIterator;
import com.cosylab.logging.client.cache.LogMultiFileCache;
import com.cosylab.logging.engine.log.ILogEntry;
import com.cosylab.logging.engine.log.LogField;
import com.cosylab.logging.engine.log.LogTypeHelper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class LogCache
extends LogMultiFileCache
implements ILogMap {
    public static final String CACHESIZE_PROPERTY_NAME = "jlog.cache.size";
    public static final int DEFAULT_CACHESIZE = 16384;
    private final int actualCacheSize;
    private final Map<Integer, ILogEntry> cache = Collections.synchronizedMap(new HashMap());
    private final LinkedList<Integer> manager = new LinkedList();
    private final Map<Integer, LogTypeHelper> logTypes = Collections.synchronizedMap(new HashMap());
    private final Map<Integer, Long> logTimes = Collections.synchronizedMap(new HashMap());

    public LogCache() throws LogCacheException {
        this(LogCache.getDefaultCacheSize());
    }

    public LogCache(int size) throws LogCacheException {
        if (size <= 0) {
            throw new LogCacheException("Invalid initial size: " + size);
        }
        this.actualCacheSize = size;
        System.out.println("Jlog will use cache for " + this.actualCacheSize + " log records.");
    }

    @Override
    public synchronized int add(ILogEntry log) throws LogCacheException {
        Integer key = super.add(log);
        this.logTypes.put(key, log.getType());
        this.logTimes.put(key, (Long)log.getField(LogField.TIMESTAMP));
        return key;
    }

    public LogTypeHelper getLogType(Integer key) throws LogCacheException {
        if (!this.logTypes.containsKey(key)) {
            throw new LogCacheException("Error: getting the type of a deleted log " + key);
        }
        return this.logTypes.get(key);
    }

    public Long getLogTimestamp(Integer key) throws LogCacheException {
        if (!this.logTimes.containsKey(key)) {
            throw new LogCacheException("Error: getting the time of a deleted log " + key);
        }
        return this.logTimes.get(key);
    }

    private static int getDefaultCacheSize() {
        Integer cacheSizeFromProperty = Integer.getInteger(CACHESIZE_PROPERTY_NAME);
        if (cacheSizeFromProperty != null) {
            return cacheSizeFromProperty;
        }
        return 16384;
    }

    @Override
    public synchronized ILogEntry getLog(Integer key) throws LogCacheException {
        ILogEntry log = this.cache.get(key);
        if (log != null) {
            return log;
        }
        return this.loadNewLog(key);
    }

    private synchronized ILogEntry loadNewLog(Integer idx) throws LogCacheException {
        ILogEntry log = super.getLog(idx);
        if (this.cache.size() == this.actualCacheSize) {
            Integer itemToRemove = this.manager.removeFirst();
            this.cache.remove(itemToRemove);
        }
        this.cache.put(idx, log);
        this.manager.addLast(idx);
        return log;
    }

    @Override
    public synchronized void clear() throws LogCacheException {
        this.cache.clear();
        this.manager.clear();
        this.logTypes.clear();
        this.logTimes.clear();
        super.clear();
    }

    public int getCacheSize() {
        return this.actualCacheSize;
    }

    public synchronized Calendar getTimeFrame() {
        Calendar cal = Calendar.getInstance();
        long min = Long.MAX_VALUE;
        long max = -1L;
        int len = this.logTimes.size();
        if (len <= 1) {
            cal.setTimeInMillis(0L);
            return cal;
        }
        Collection<Long> times = this.logTimes.values();
        for (Long time : times) {
            if (time > max) {
                max = time;
            }
            if (time >= min) continue;
            min = time;
        }
        cal.setTimeInMillis(max - min);
        return cal;
    }

    @Override
    public synchronized void deleteLog(Integer key) throws LogCacheException {
        if (this.cache.containsKey(key)) {
            this.cache.remove(key);
            this.manager.remove(key);
        }
        this.logTimes.remove(key);
        this.logTypes.remove(key);
        super.deleteLog(key);
    }

    public void deleteLogs(final Integer[] keys) throws LogCacheException {
        Thread t = new Thread("LogCache.deleteLogs"){

            @Override
            public void run() {
                for (Integer key : keys) {
                    try {
                        LogCache.this.deleteLog(key);
                    }
                    catch (Throwable t) {
                        System.err.println("Error removing log[" + key + "] from LogCache: " + t.getMessage());
                    }
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    public synchronized Collection<Integer> getLogExceedingTimeFrame(long timeframe) {
        long newestTime = -1L;
        Collection<Long> times = this.logTimes.values();
        for (Long time : times) {
            if (time <= newestTime) continue;
            newestTime = time;
        }
        long limit = newestTime - timeframe;
        ArrayList<Integer> ret = new ArrayList<Integer>();
        Set<Integer> keys = this.logTimes.keySet();
        for (Integer key : keys) {
            if (this.logTimes.get(key) <= limit) continue;
            ret.add(key);
        }
        return ret;
    }

    @Override
    public Set<Integer> keySet() {
        return this.logTimes.keySet();
    }

    @Override
    public Iterator<ILogEntry> iterator() {
        return new LogIterator(this);
    }
}

