/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.logging.settings;

import alma.acs.gui.widgets.DateTimeSelector;
import com.cosylab.logging.engine.Filter;
import com.cosylab.logging.engine.InvalidFilterConstraintException;
import com.cosylab.logging.engine.MinMaxFilter;
import com.cosylab.logging.settings.FilterParameterException;
import com.cosylab.logging.settings.FilterParameterPanel;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JCheckBox;

public class FilterDatePanel
extends FilterParameterPanel {
    private DateTimeSelector minimum;
    private DateTimeSelector maximum;
    private JCheckBox minimumCheck;
    private JCheckBox maximumCheck;
    private JCheckBox notCheck;

    @Override
    protected void createComponents() {
        this.notCheck = new JCheckBox("Discard entries matching this filter");
        this.notCheck.setToolTipText("Keep/discard entries matching this filter");
        this.add((Component)this.notCheck, this.newConstraints(0, 4, 4, 4, 4));
        this.minimumCheck = new JCheckBox("From");
        this.add((Component)this.minimumCheck, this.newConstraints(1, 4, 4, 0, 4));
        this.minimum = new DateTimeSelector();
        this.add((Component)this.minimum, this.newConstraints(2, 0, 4, 4, 4));
        this.maximumCheck = new JCheckBox("To");
        this.add((Component)this.maximumCheck, this.newConstraints(3, 4, 4, 0, 4));
        this.maximum = new DateTimeSelector();
        this.add((Component)this.maximum, this.newConstraints(4, 0, 4, 4, 4));
    }

    @Override
    public Filter getFilter() throws FilterParameterException {
        Date min = null;
        Date max = null;
        if (this.minimumCheck.isSelected()) {
            min = this.minimum.getDate().getTime();
        }
        if (this.maximumCheck.isSelected()) {
            max = this.maximum.getDate().getTime();
        }
        if (min == null && max == null) {
            throw new FilterParameterException("Select at least one constraint");
        }
        if (min != null && max != null && min.compareTo(max) > -1) {
            throw new FilterParameterException("From must be less than To");
        }
        try {
            return new MinMaxFilter(this.getFieldIndex(), this.isLethal(), (Comparable)min, (Comparable)max, this.notCheck.isSelected());
        }
        catch (InvalidFilterConstraintException e) {
            throw new FilterParameterException(e.getMessage());
        }
    }

    @Override
    public void setFilter(Filter f) {
        Calendar cal;
        if (f == null) {
            return;
        }
        if (f.getConstraint() == Filter.Constraint.MINMAX || f.getConstraint() == Filter.Constraint.MINIMUM) {
            cal = Calendar.getInstance();
            cal.setTime(new Date((Long)((MinMaxFilter)f).getMinimum()));
            this.minimum.setDate(cal);
            this.minimumCheck.setSelected(true);
        } else {
            this.minimumCheck.setSelected(false);
        }
        if (f.getConstraint() == Filter.Constraint.MINMAX || f.getConstraint() == Filter.Constraint.MAXIMUM) {
            cal = Calendar.getInstance();
            cal.setTime(new Date((Long)((MinMaxFilter)f).getMaximum()));
            this.maximum.setDate(cal);
            this.maximumCheck.setSelected(true);
        } else {
            this.maximumCheck.setSelected(false);
        }
        this.notCheck.setSelected(f.notPolicyApplyed());
    }
}

