/*
 * Decompiled with CFR 0.152.
 */
package alma.common.sourcecatalog.flatfile;

import alma.common.sourcecatalog.CatalogQueryParameters;
import alma.common.sourcecatalog.Measurement;
import alma.common.sourcecatalog.flatfile.FlatFileSortField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import jsky.coords.CoordinateRadius;
import jsky.coords.Coordinates;
import jsky.coords.WorldCoords;

public class MeasurementFilter {
    public static List<Measurement> filterMeasurements(Collection<Measurement> pool, CatalogQueryParameters query) {
        List<Measurement> matching = new ArrayList<Measurement>();
        matching.addAll(pool);
        if (query.hasName()) {
            matching = MeasurementFilter.matchName(matching, query.getName());
        }
        if (query.hasRadius() && query.hasRightAscension() && query.hasDeclination()) {
            matching = MeasurementFilter.matchConeSearch(matching, query.getRightAscension(), query.getDeclination(), query.getRadius());
        }
        if (query.hasMinFlux()) {
            matching = MeasurementFilter.matchFluxGreaterThan(matching, query.getMinFlux());
        }
        if (query.hasMaxFlux()) {
            matching = MeasurementFilter.matchFluxLessThan(matching, query.getMaxFlux());
        }
        if (query.hasMinFrequency()) {
            matching = MeasurementFilter.matchFrequencyGreaterThan(matching, query.getMinFrequency());
        }
        if (query.hasMaxFrequency()) {
            matching = MeasurementFilter.matchFrequencyLessThan(matching, query.getMaxFrequency());
        }
        if (query.hasEarliestObservation()) {
            matching = MeasurementFilter.matchLater(matching, query.getEarliestObservation());
        }
        if (query.hasLatestObservation()) {
            matching = MeasurementFilter.matchEarlier(matching, query.getLatestObservation());
        }
        if (query.hasSortBy()) {
            matching = MeasurementFilter.sortBy(matching, query.getSortBy());
        }
        if (!query.getSortAscending()) {
            Collections.reverse(matching);
        }
        matching = MeasurementFilter.truncate(matching, query.getMaxSources());
        return matching;
    }

    private static List<Measurement> sortBy(List<Measurement> matching, String sortBy) {
        FlatFileSortField f = FlatFileSortField.byName(sortBy);
        if (f == null) {
            return matching;
        }
        Collections.sort(matching, f.getComparator());
        return matching;
    }

    private static List<Measurement> truncate(List<Measurement> pool, Integer maxSources) {
        if (maxSources == null || pool.isEmpty()) {
            return Collections.emptyList();
        }
        if (pool.size() > maxSources) {
            return new ArrayList<Measurement>(pool.subList(0, maxSources));
        }
        return pool;
    }

    private static List<Measurement> matchConeSearch(Collection<Measurement> pool, Double rightAscension, Double declination, Double radius) {
        if (rightAscension == null || declination == null || radius == null || pool.isEmpty()) {
            return Collections.emptyList();
        }
        WorldCoords coords = new WorldCoords(rightAscension, declination);
        CoordinateRadius cr = new CoordinateRadius((Coordinates)coords, radius * 60.0);
        ArrayList<Measurement> matching = new ArrayList<Measurement>();
        for (Measurement m : pool) {
            WorldCoords pos;
            Double ra = m.getRa();
            Double dec = m.getDec();
            if (ra == null || dec == null || !cr.contains((Coordinates)(pos = new WorldCoords(ra, dec)))) continue;
            matching.add(m);
        }
        return matching;
    }

    private static List<Measurement> matchFluxLessThan(List<Measurement> pool, Double threshold) {
        if (threshold == null || pool.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Measurement> matching = new ArrayList<Measurement>();
        for (Measurement m : pool) {
            Double flux = m.getFlux();
            if (flux == null || flux.compareTo(threshold) > 0) continue;
            matching.add(m);
        }
        return matching;
    }

    private static List<Measurement> matchFluxGreaterThan(List<Measurement> pool, Double threshold) {
        if (threshold == null || pool.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Measurement> matching = new ArrayList<Measurement>();
        for (Measurement m : pool) {
            Double flux = m.getFlux();
            if (flux == null || flux.compareTo(threshold) < 0) continue;
            matching.add(m);
        }
        return matching;
    }

    private static List<Measurement> matchFrequencyLessThan(List<Measurement> pool, Double threshold) {
        if (threshold == null || pool.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Measurement> matching = new ArrayList<Measurement>();
        for (Measurement m : pool) {
            Double frequency = m.getFrequency();
            if (frequency == null || frequency.compareTo(threshold) > 0) continue;
            matching.add(m);
        }
        return matching;
    }

    private static List<Measurement> matchFrequencyGreaterThan(List<Measurement> pool, Double threshold) {
        if (threshold == null || pool.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Measurement> matching = new ArrayList<Measurement>();
        for (Measurement m : pool) {
            Double frequency = m.getFrequency();
            if (frequency == null || frequency.compareTo(threshold) < 0) continue;
            matching.add(m);
        }
        return matching;
    }

    private static List<Measurement> matchName(List<Measurement> pool, String name) {
        if (name == null || pool.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Measurement> matching = new ArrayList<Measurement>();
        for (Measurement m : pool) {
            for (String s : m.getNames()) {
                if (!s.toUpperCase().equals(name.toUpperCase())) continue;
                matching.add(m);
            }
        }
        return matching;
    }

    private static List<Measurement> matchLater(List<Measurement> pool, Date date) {
        if (date == null || pool.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Measurement> matching = new ArrayList<Measurement>();
        for (Measurement m : pool) {
            Date observed = m.getDateObserved();
            if (observed == null || observed.compareTo(date) == -1) continue;
            matching.add(m);
        }
        return matching;
    }

    private static List<Measurement> matchEarlier(List<Measurement> pool, Date date) {
        if (date == null || pool.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Measurement> matching = new ArrayList<Measurement>();
        for (Measurement m : pool) {
            Date observed = m.getDateObserved();
            if (observed == null || observed.compareTo(date) == 1) continue;
            matching.add(m);
        }
        return matching;
    }
}

