/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.gui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jsky.catalog.gui.CatalogQueryItem;
import jsky.util.Preferences;

public class CatalogQueryList {
    private static final String QUERY_LIST_NAME = "catalogQueryList";
    private List<CatalogQueryItem> _queryList;

    public CatalogQueryList() {
        this._load();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                CatalogQueryList.this._save();
            }
        });
    }

    public void add(CatalogQueryItem queryItem) {
        this.remove(queryItem.getName());
        this._queryList.add(queryItem);
    }

    public void remove(String name) {
        for (CatalogQueryItem item : new ArrayList<CatalogQueryItem>(this._queryList)) {
            if (!item.getName().equals(name)) continue;
            this._queryList.remove(item);
            break;
        }
    }

    public Iterator iterator() {
        return this._queryList.iterator();
    }

    public int size() {
        return this._queryList.size();
    }

    public void clear() {
        this._queryList = new ArrayList<CatalogQueryItem>();
        this._save();
    }

    private void _load() {
        try {
            this._queryList = (List)Preferences.getPreferences().deserialize(QUERY_LIST_NAME);
        }
        catch (Exception e) {
            this._queryList = new ArrayList<CatalogQueryItem>();
        }
    }

    private void _save() {
        try {
            Preferences.getPreferences().serialize(QUERY_LIST_NAME, this._queryList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

