/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.ukatc.xsltchain;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import org.xml.sax.SAXException;
import uk.ac.roe.ukatc.xsltchain.ChainTranslator;
import uk.ac.roe.ukatc.xsltchain.UGraph;
import uk.ac.roe.ukatc.xsltchain.XsltChainException;

public class XsltChain {
    Map<String, UGraph> versionTable = new HashMap<String, UGraph>();

    XsltChain() {
    }

    void addTranslator(String xsd, String in_ver, String out_ver, String tx) {
        UGraph g = this.getGraph(xsd);
        g.addEdge(in_ver, out_ver, tx);
    }

    UGraph getGraph(String xsd) {
        if (this.versionTable.containsKey(xsd)) {
            return this.versionTable.get(xsd);
        }
        UGraph g = new UGraph();
        this.versionTable.put(xsd, g);
        return g;
    }

    void addTranslatorsFromStream(String xsd, InputStream is) {
        UGraph g = this.getGraph(xsd);
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            while ((line = in.readLine()) != null) {
                if (line.startsWith("#")) continue;
                StringTokenizer st = new StringTokenizer(line);
                try {
                    if (st.countTokens() != 3) {
                        System.err.println("Skipping ill-formatted line " + line);
                        continue;
                    }
                    String source = st.nextToken();
                    String dest = st.nextToken();
                    String data = st.nextToken();
                    g.addEdge(source, dest, data);
                }
                catch (NumberFormatException e) {
                    System.err.println("Skipping ill-formatted line " + line);
                }
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    void addTranslatorsFromStream(InputStream is) {
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            while ((line = in.readLine()) != null) {
                if (line.startsWith("#")) continue;
                StringTokenizer st = new StringTokenizer(line);
                try {
                    if (st.countTokens() != 4) {
                        System.err.println("Skipping ill-formatted line " + line);
                        continue;
                    }
                    String xsd = st.nextToken();
                    String source = st.nextToken();
                    String dest = st.nextToken();
                    String data = st.nextToken();
                    this.addTranslator(xsd, source, dest, data);
                }
                catch (NumberFormatException e) {
                    System.err.println("Skipping ill-formatted line " + line);
                }
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    boolean hasTranslation(String xsd, String in_ver, String out_ver) {
        if (!this.versionTable.containsKey(xsd)) {
            return false;
        }
        UGraph graph = this.versionTable.get(xsd);
        return graph.getShortestPath(in_ver, out_ver) != null;
    }

    List getTranslationList(String xsd, String in_ver, String out_ver) throws XsltChainException {
        if (!this.versionTable.containsKey(xsd)) {
            throw new XsltChainException("No transforms recorded for XSD");
        }
        UGraph graph = this.versionTable.get(xsd);
        List l = graph.getShortestPath(in_ver, out_ver);
        if (l == null) {
            throw new XsltChainException("No transforms recorded for versions");
        }
        return l;
    }

    ChainTranslator getChainTranslator(String xsd, String in_ver, String out_ver) throws ParserConfigurationException, SAXException, TransformerConfigurationException, MalformedURLException, IOException, XsltChainException {
        ChainTranslator ctx = new ChainTranslator();
        List l = this.getTranslationList(xsd, in_ver, out_ver);
        for (String s : l) {
            ctx.AddFilter(new URL(s));
        }
        return ctx;
    }

    ChainTranslator getChainTranslator(String xsd, String in_ver, String out_ver, URL base) throws ParserConfigurationException, SAXException, TransformerConfigurationException, MalformedURLException, IOException, XsltChainException {
        ChainTranslator ctx = new ChainTranslator();
        List l = this.getTranslationList(xsd, in_ver, out_ver);
        for (String s : l) {
            ctx.AddFilter(new URL(base, s));
        }
        return ctx;
    }
}

