/*
 * Decompiled with CFR 0.152.
 */
package alma.valuetypes.data;

import alma.entity.xmlbinding.valuetypes.SpeedT;
import alma.entity.xmlbinding.valuetypes.VelocityT;
import alma.entity.xmlbinding.valuetypes.types.VelocityTDopplerCalcTypeType;
import alma.entity.xmlbinding.valuetypes.types.VelocityTReferenceSystemType;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.Copier;
import alma.hla.runtime.obsprep.bo.CopyException;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.bo.ReferenceablesMap;
import alma.hla.runtime.obsprep.bo.Referring;
import alma.valuetypes.Speed;
import alma.valuetypes.Velocity;
import java.util.List;

public class VelocityData
extends BusinessObject {
    public static final String REFERENCESYSTEM_BAR = VelocityTReferenceSystemType.BAR.toString();
    public static final String REFERENCESYSTEM_LSRK = VelocityTReferenceSystemType.LSRK.toString();
    public static final String REFERENCESYSTEM_TOPO = VelocityTReferenceSystemType.TOPO.toString();
    public static final String REFERENCESYSTEM_HEL = VelocityTReferenceSystemType.HEL.toString();
    public static final String REFERENCESYSTEM_LSR = VelocityTReferenceSystemType.LSR.toString();
    public static final String DOPPLERCALCTYPE_RADIO = VelocityTDopplerCalcTypeType.RADIO.toString();
    public static final String DOPPLERCALCTYPE_OPTICAL = VelocityTDopplerCalcTypeType.OPTICAL.toString();
    public static final String DOPPLERCALCTYPE_RELATIVISTIC = VelocityTDopplerCalcTypeType.RELATIVISTIC.toString();
    protected static String[] knownReferenceSystemList = new String[]{REFERENCESYSTEM_BAR, REFERENCESYSTEM_LSRK, REFERENCESYSTEM_TOPO, REFERENCESYSTEM_HEL, REFERENCESYSTEM_LSR};
    protected static String[] knownDopplerCalcTypeList = new String[]{DOPPLERCALCTYPE_RADIO, DOPPLERCALCTYPE_OPTICAL, DOPPLERCALCTYPE_RELATIVISTIC};
    private Speed boCenterVelocity = null;

    protected VelocityData(VelocityT castorObject) {
        super(castorObject);
    }

    public static VelocityT testsupport_createVelocityT() {
        return Velocity.createVelocityT();
    }

    protected static final VelocityT createVelocityT() {
        VelocityT ret = new VelocityT();
        Velocity.patchVelocityT((VelocityT)ret);
        return ret;
    }

    private static final Velocity createUnitializedVelocity() {
        VelocityT so = Velocity.createVelocityT();
        Velocity ret = new Velocity(so);
        return ret;
    }

    public static Velocity createVelocity() {
        VelocityT so = Velocity.createVelocityT();
        Velocity ret = new Velocity(so);
        ret.initAsNew();
        return ret;
    }

    protected static final void patchVelocityT(VelocityT castorObject) {
    }

    @Override
    public VelocityT getCastorObject() {
        return (VelocityT)this.storageObject;
    }

    public Velocity deepCopy() throws CopyException {
        return (Velocity)super.deepCopy();
    }

    protected Velocity invokeCreateUnitialized() throws CopyException {
        return VelocityData.createUnitializedVelocity();
    }

    @Override
    protected void initAttribsAndPartsFrom(IBusinessObject original, Copier copier) throws CopyException {
        super.initAttribsAndPartsFrom(original, copier);
        VelocityData orig = (VelocityData)original;
        if (orig.gettrueCenterVelocity() != null) {
            this.setCenterVelocity((Speed)copier.cpAttr((BusinessObject)orig.gettrueCenterVelocity()));
        }
        if (orig.getReferenceSystem() != null) {
            this.setReferenceSystem(orig.getReferenceSystem());
        }
        if (orig.getDopplerCalcType() != null) {
            this.setDopplerCalcType(orig.getDopplerCalcType());
        }
    }

    @Override
    protected void initEntityReferencesFrom(IBusinessObject original, Copier copier) throws CopyException {
        super.initEntityReferencesFrom(original, copier);
        VelocityData orig = (VelocityData)original;
    }

    public void wrapObjects(ReferenceablesMap referencedObjects, List referrers) {
        super.wrapObjects(referencedObjects, referrers);
        this.wrapCenterVelocity();
    }

    @Override
    public List<IBusinessObject> referencedBOs(Referring.By ... bys) {
        List<IBusinessObject> r = super.referencedBOs(bys);
        block5: for (Referring.By by : bys) {
            switch (by) {
                case UmlComposition: {
                    continue block5;
                }
                case UmlUnidir: {
                    continue block5;
                }
                case UmlAttribution: {
                    this.addToCollection(r, this.gettrueCenterVelocity());
                }
            }
        }
        return r;
    }

    private void wrapCenterVelocity() {
        SpeedT subSo = this.getCastorObject().getCenterVelocity();
        if (subSo != null) {
            Speed subBo;
            this.boCenterVelocity = subBo = new Speed(subSo);
        }
    }

    public void setCenterVelocity(Speed newValue) {
        VelocityT castorObject = this.getCastorObject();
        SpeedT subCastorObject = newValue.getCastorObject();
        castorObject.setCenterVelocity(subCastorObject);
        this.boCenterVelocity = newValue;
        String propName = "alma.valuetypes.Velocity.centerVelocity";
        Speed propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.valuetypes.Velocity.centerVelocity", propValue);
    }

    public Speed gettrueCenterVelocity() {
        Speed ret = this.boCenterVelocity;
        return ret;
    }

    public Speed getCenterVelocity() {
        Speed ret = this.gettrueCenterVelocity();
        if (ret == null) {
            ret = Speed.createSpeed();
            this.setCenterVelocity(ret);
        }
        return ret;
    }

    public void setReferenceSystem(String newValue) throws IllegalArgumentException {
        VelocityT castorObject = this.getCastorObject();
        VelocityTReferenceSystemType castorEnumElement = VelocityTReferenceSystemType.valueOf(newValue);
        castorObject.setReferenceSystem(castorEnumElement);
        String propName = "alma.valuetypes.Velocity.referenceSystem";
        String propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.valuetypes.Velocity.referenceSystem", propValue);
    }

    public String getReferenceSystem() {
        VelocityT castorObject = this.getCastorObject();
        VelocityTReferenceSystemType value = castorObject.getReferenceSystem();
        String ret = value == null ? null : value.toString();
        return ret;
    }

    public static String[] getKnownReferenceSystemList() {
        return knownReferenceSystemList;
    }

    public void setDopplerCalcType(String newValue) throws IllegalArgumentException {
        VelocityT castorObject = this.getCastorObject();
        VelocityTDopplerCalcTypeType castorEnumElement = VelocityTDopplerCalcTypeType.valueOf(newValue);
        castorObject.setDopplerCalcType(castorEnumElement);
        String propName = "alma.valuetypes.Velocity.dopplerCalcType";
        String propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.valuetypes.Velocity.dopplerCalcType", propValue);
    }

    public String getDopplerCalcType() {
        VelocityT castorObject = this.getCastorObject();
        VelocityTDopplerCalcTypeType value = castorObject.getDopplerCalcType();
        String ret = value == null ? null : value.toString();
        return ret;
    }

    public static String[] getKnownDopplerCalcTypeList() {
        return knownDopplerCalcTypeList;
    }
}

